/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EffectiveRouteSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EffectiveRouteState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.RouteNextHopType;
import java.io.IOException;
import java.util.List;

public final class EffectiveRoute
implements JsonSerializable<EffectiveRoute> {
    private String name;
    private Boolean disableBgpRoutePropagation;
    private EffectiveRouteSource source;
    private EffectiveRouteState state;
    private List<String> addressPrefix;
    private List<String> nextHopIpAddress;
    private RouteNextHopType nextHopType;

    public String name() {
        return this.name;
    }

    public EffectiveRoute withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean disableBgpRoutePropagation() {
        return this.disableBgpRoutePropagation;
    }

    public EffectiveRoute withDisableBgpRoutePropagation(Boolean disableBgpRoutePropagation) {
        this.disableBgpRoutePropagation = disableBgpRoutePropagation;
        return this;
    }

    public EffectiveRouteSource source() {
        return this.source;
    }

    public EffectiveRoute withSource(EffectiveRouteSource source2) {
        this.source = source2;
        return this;
    }

    public EffectiveRouteState state() {
        return this.state;
    }

    public EffectiveRoute withState(EffectiveRouteState state) {
        this.state = state;
        return this;
    }

    public List<String> addressPrefix() {
        return this.addressPrefix;
    }

    public EffectiveRoute withAddressPrefix(List<String> addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public List<String> nextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    public EffectiveRoute withNextHopIpAddress(List<String> nextHopIpAddress) {
        this.nextHopIpAddress = nextHopIpAddress;
        return this;
    }

    public RouteNextHopType nextHopType() {
        return this.nextHopType;
    }

    public EffectiveRoute withNextHopType(RouteNextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("disableBgpRoutePropagation", this.disableBgpRoutePropagation);
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("addressPrefix", this.addressPrefix, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("nextHopIpAddress", this.nextHopIpAddress, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("nextHopType", this.nextHopType == null ? null : this.nextHopType.toString());
        return jsonWriter.writeEndObject();
    }

    public static EffectiveRoute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveRoute deserializedEffectiveRoute = new EffectiveRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedEffectiveRoute.name = reader.getString();
                    continue;
                }
                if ("disableBgpRoutePropagation".equals(fieldName)) {
                    deserializedEffectiveRoute.disableBgpRoutePropagation = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedEffectiveRoute.source = EffectiveRouteSource.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedEffectiveRoute.state = EffectiveRouteState.fromString(reader.getString());
                    continue;
                }
                if ("addressPrefix".equals(fieldName)) {
                    List<String> addressPrefix = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveRoute.addressPrefix = addressPrefix;
                    continue;
                }
                if ("nextHopIpAddress".equals(fieldName)) {
                    List<String> nextHopIpAddress = reader.readArray(reader1 -> reader1.getString());
                    deserializedEffectiveRoute.nextHopIpAddress = nextHopIpAddress;
                    continue;
                }
                if ("nextHopType".equals(fieldName)) {
                    deserializedEffectiveRoute.nextHopType = RouteNextHopType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEffectiveRoute;
        });
    }
}

