/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.HopLinkProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConnectivityIssue;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class HopLink
implements JsonSerializable<HopLink> {
    private String nextHopId;
    private String linkType;
    private HopLinkProperties innerProperties;
    private List<ConnectivityIssue> issues;
    private Map<String, String> context;
    private String resourceId;

    public String nextHopId() {
        return this.nextHopId;
    }

    public String linkType() {
        return this.linkType;
    }

    private HopLinkProperties innerProperties() {
        return this.innerProperties;
    }

    public List<ConnectivityIssue> issues() {
        return this.issues;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public Long roundTripTimeMin() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeMin();
    }

    public Long roundTripTimeAvg() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeAvg();
    }

    public Long roundTripTimeMax() {
        return this.innerProperties() == null ? null : this.innerProperties().roundTripTimeMax();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.issues() != null) {
            this.issues().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static HopLink fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HopLink deserializedHopLink = new HopLink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextHopId".equals(fieldName)) {
                    deserializedHopLink.nextHopId = reader.getString();
                    continue;
                }
                if ("linkType".equals(fieldName)) {
                    deserializedHopLink.linkType = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedHopLink.innerProperties = HopLinkProperties.fromJson(reader);
                    continue;
                }
                if ("issues".equals(fieldName)) {
                    List<ConnectivityIssue> issues = reader.readArray(reader1 -> ConnectivityIssue.fromJson(reader1));
                    deserializedHopLink.issues = issues;
                    continue;
                }
                if ("context".equals(fieldName)) {
                    Map<String, String> context = reader.readMap(reader1 -> reader1.getString());
                    deserializedHopLink.context = context;
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedHopLink.resourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHopLink;
        });
    }
}

