/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class HubRoute
implements JsonSerializable<HubRoute> {
    private String name;
    private String destinationType;
    private List<String> destinations;
    private String nextHopType;
    private String nextHop;
    private static final ClientLogger LOGGER = new ClientLogger(HubRoute.class);

    public String name() {
        return this.name;
    }

    public HubRoute withName(String name) {
        this.name = name;
        return this;
    }

    public String destinationType() {
        return this.destinationType;
    }

    public HubRoute withDestinationType(String destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    public List<String> destinations() {
        return this.destinations;
    }

    public HubRoute withDestinations(List<String> destinations) {
        this.destinations = destinations;
        return this;
    }

    public String nextHopType() {
        return this.nextHopType;
    }

    public HubRoute withNextHopType(String nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    public String nextHop() {
        return this.nextHop;
    }

    public HubRoute withNextHop(String nextHop) {
        this.nextHop = nextHop;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property name in model HubRoute"));
        }
        if (this.destinationType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property destinationType in model HubRoute"));
        }
        if (this.destinations() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property destinations in model HubRoute"));
        }
        if (this.nextHopType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property nextHopType in model HubRoute"));
        }
        if (this.nextHop() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property nextHop in model HubRoute"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("destinationType", this.destinationType);
        jsonWriter.writeArrayField("destinations", this.destinations, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("nextHopType", this.nextHopType);
        jsonWriter.writeStringField("nextHop", this.nextHop);
        return jsonWriter.writeEndObject();
    }

    public static HubRoute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HubRoute deserializedHubRoute = new HubRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHubRoute.name = reader.getString();
                    continue;
                }
                if ("destinationType".equals(fieldName)) {
                    deserializedHubRoute.destinationType = reader.getString();
                    continue;
                }
                if ("destinations".equals(fieldName)) {
                    List<String> destinations = reader.readArray(reader1 -> reader1.getString());
                    deserializedHubRoute.destinations = destinations;
                    continue;
                }
                if ("nextHopType".equals(fieldName)) {
                    deserializedHubRoute.nextHopType = reader.getString();
                    continue;
                }
                if ("nextHop".equals(fieldName)) {
                    deserializedHubRoute.nextHop = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHubRoute;
        });
    }
}

