/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancerSkuName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LoadBalancerSkuType {
    private static final Map<String, LoadBalancerSkuType> VALUES_BY_NAME = new HashMap<String, LoadBalancerSkuType>();
    public static final LoadBalancerSkuType BASIC = new LoadBalancerSkuType(LoadBalancerSkuName.BASIC);
    public static final LoadBalancerSkuType STANDARD = new LoadBalancerSkuType(LoadBalancerSkuName.STANDARD);
    private final LoadBalancerSkuName skuName;

    public static LoadBalancerSkuType[] values() {
        Collection<LoadBalancerSkuType> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new LoadBalancerSkuType[valuesCollection.size()]);
    }

    private LoadBalancerSkuType(LoadBalancerSkuName skuName) {
        this.skuName = skuName;
        if (skuName != null) {
            VALUES_BY_NAME.put(skuName.toString().toLowerCase(Locale.ROOT), this);
        }
    }

    public static LoadBalancerSkuType fromSku(LoadBalancerSku lbSku) {
        if (lbSku == null) {
            return null;
        }
        if (lbSku.name() == null) {
            return null;
        }
        LoadBalancerSkuType result = VALUES_BY_NAME.get(lbSku.name().toString().toLowerCase(Locale.ROOT));
        if (result != null) {
            return result;
        }
        return new LoadBalancerSkuType(lbSku.name());
    }

    public LoadBalancerSku sku() {
        return new LoadBalancerSku().withName(this.skuName);
    }

    public int hashCode() {
        return this.skuName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LoadBalancerSkuType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.skuName == null) {
            return ((LoadBalancerSkuType)obj).skuName == null;
        }
        return this.skuName.equals(((LoadBalancerSkuType)obj).skuName);
    }
}

