/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ActionType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedRuleEnabledState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SensitivityType;
import java.io.IOException;

public final class ManagedRuleOverride
implements JsonSerializable<ManagedRuleOverride> {
    private String ruleId;
    private ManagedRuleEnabledState state;
    private ActionType action;
    private SensitivityType sensitivity;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleOverride.class);

    public String ruleId() {
        return this.ruleId;
    }

    public ManagedRuleOverride withRuleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public ManagedRuleEnabledState state() {
        return this.state;
    }

    public ManagedRuleOverride withState(ManagedRuleEnabledState state) {
        this.state = state;
        return this;
    }

    public ActionType action() {
        return this.action;
    }

    public ManagedRuleOverride withAction(ActionType action) {
        this.action = action;
        return this;
    }

    public SensitivityType sensitivity() {
        return this.sensitivity;
    }

    public ManagedRuleOverride withSensitivity(SensitivityType sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    public void validate() {
        if (this.ruleId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ruleId in model ManagedRuleOverride"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleId", this.ruleId);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("sensitivity", this.sensitivity == null ? null : this.sensitivity.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedRuleOverride fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedRuleOverride deserializedManagedRuleOverride = new ManagedRuleOverride();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleId".equals(fieldName)) {
                    deserializedManagedRuleOverride.ruleId = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedManagedRuleOverride.state = ManagedRuleEnabledState.fromString(reader.getString());
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedManagedRuleOverride.action = ActionType.fromString(reader.getString());
                    continue;
                }
                if ("sensitivity".equals(fieldName)) {
                    deserializedManagedRuleOverride.sensitivity = SensitivityType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedRuleOverride;
        });
    }
}

