/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.FirewallPolicyRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.FirewallPolicyRuleNetworkProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.FirewallPolicyRuleType;
import java.io.IOException;
import java.util.List;

public final class NetworkRule
extends FirewallPolicyRule {
    private FirewallPolicyRuleType ruleType = FirewallPolicyRuleType.NETWORK_RULE;
    private List<FirewallPolicyRuleNetworkProtocol> ipProtocols;
    private List<String> sourceAddresses;
    private List<String> destinationAddresses;
    private List<String> destinationPorts;
    private List<String> sourceIpGroups;
    private List<String> destinationIpGroups;
    private List<String> destinationFqdns;

    @Override
    public FirewallPolicyRuleType ruleType() {
        return this.ruleType;
    }

    public List<FirewallPolicyRuleNetworkProtocol> ipProtocols() {
        return this.ipProtocols;
    }

    public NetworkRule withIpProtocols(List<FirewallPolicyRuleNetworkProtocol> ipProtocols) {
        this.ipProtocols = ipProtocols;
        return this;
    }

    public List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    public NetworkRule withSourceAddresses(List<String> sourceAddresses) {
        this.sourceAddresses = sourceAddresses;
        return this;
    }

    public List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    public NetworkRule withDestinationAddresses(List<String> destinationAddresses) {
        this.destinationAddresses = destinationAddresses;
        return this;
    }

    public List<String> destinationPorts() {
        return this.destinationPorts;
    }

    public NetworkRule withDestinationPorts(List<String> destinationPorts) {
        this.destinationPorts = destinationPorts;
        return this;
    }

    public List<String> sourceIpGroups() {
        return this.sourceIpGroups;
    }

    public NetworkRule withSourceIpGroups(List<String> sourceIpGroups) {
        this.sourceIpGroups = sourceIpGroups;
        return this;
    }

    public List<String> destinationIpGroups() {
        return this.destinationIpGroups;
    }

    public NetworkRule withDestinationIpGroups(List<String> destinationIpGroups) {
        this.destinationIpGroups = destinationIpGroups;
        return this;
    }

    public List<String> destinationFqdns() {
        return this.destinationFqdns;
    }

    public NetworkRule withDestinationFqdns(List<String> destinationFqdns) {
        this.destinationFqdns = destinationFqdns;
        return this;
    }

    @Override
    public NetworkRule withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public NetworkRule withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeArrayField("ipProtocols", this.ipProtocols, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("sourceAddresses", this.sourceAddresses, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("destinationAddresses", this.destinationAddresses, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("destinationPorts", this.destinationPorts, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("sourceIpGroups", this.sourceIpGroups, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("destinationIpGroups", this.destinationIpGroups, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("destinationFqdns", this.destinationFqdns, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkRule deserializedNetworkRule = new NetworkRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkRule.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedNetworkRule.withDescription(reader.getString());
                    continue;
                }
                if ("ruleType".equals(fieldName)) {
                    deserializedNetworkRule.ruleType = FirewallPolicyRuleType.fromString(reader.getString());
                    continue;
                }
                if ("ipProtocols".equals(fieldName)) {
                    List<FirewallPolicyRuleNetworkProtocol> ipProtocols = reader.readArray(reader1 -> FirewallPolicyRuleNetworkProtocol.fromString(reader1.getString()));
                    deserializedNetworkRule.ipProtocols = ipProtocols;
                    continue;
                }
                if ("sourceAddresses".equals(fieldName)) {
                    List<String> sourceAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkRule.sourceAddresses = sourceAddresses;
                    continue;
                }
                if ("destinationAddresses".equals(fieldName)) {
                    List<String> destinationAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkRule.destinationAddresses = destinationAddresses;
                    continue;
                }
                if ("destinationPorts".equals(fieldName)) {
                    List<String> destinationPorts = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkRule.destinationPorts = destinationPorts;
                    continue;
                }
                if ("sourceIpGroups".equals(fieldName)) {
                    List<String> sourceIpGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkRule.sourceIpGroups = sourceIpGroups;
                    continue;
                }
                if ("destinationIpGroups".equals(fieldName)) {
                    List<String> destinationIpGroups = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkRule.destinationIpGroups = destinationIpGroups;
                    continue;
                }
                if ("destinationFqdns".equals(fieldName)) {
                    List<String> destinationFqdns = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkRule.destinationFqdns = destinationFqdns;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkRule;
        });
    }
}

