/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IntentContent;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ReachabilityAnalysisRunProperties
implements JsonSerializable<ReachabilityAnalysisRunProperties> {
    private String description;
    private String intentId;
    private IntentContent intentContent;
    private String analysisResult;
    private String errorMessage;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ReachabilityAnalysisRunProperties.class);

    public String description() {
        return this.description;
    }

    public ReachabilityAnalysisRunProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String intentId() {
        return this.intentId;
    }

    public ReachabilityAnalysisRunProperties withIntentId(String intentId) {
        this.intentId = intentId;
        return this;
    }

    public IntentContent intentContent() {
        return this.intentContent;
    }

    public String analysisResult() {
        return this.analysisResult;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ReachabilityAnalysisRunProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public void validate() {
        if (this.intentId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property intentId in model ReachabilityAnalysisRunProperties"));
        }
        if (this.intentContent() != null) {
            this.intentContent().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("intentId", this.intentId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        return jsonWriter.writeEndObject();
    }

    public static ReachabilityAnalysisRunProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReachabilityAnalysisRunProperties deserializedReachabilityAnalysisRunProperties = new ReachabilityAnalysisRunProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("intentId".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.intentId = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.description = reader.getString();
                    continue;
                }
                if ("intentContent".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.intentContent = IntentContent.fromJson(reader);
                    continue;
                }
                if ("analysisResult".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.analysisResult = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.errorMessage = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedReachabilityAnalysisRunProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReachabilityAnalysisRunProperties;
        });
    }
}

