/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.StaticRoute;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.StaticRoutesConfig;
import java.io.IOException;
import java.util.List;

public final class VnetRoute
implements JsonSerializable<VnetRoute> {
    private StaticRoutesConfig staticRoutesConfig;
    private List<StaticRoute> staticRoutes;
    private List<SubResource> bgpConnections;

    public StaticRoutesConfig staticRoutesConfig() {
        return this.staticRoutesConfig;
    }

    public VnetRoute withStaticRoutesConfig(StaticRoutesConfig staticRoutesConfig) {
        this.staticRoutesConfig = staticRoutesConfig;
        return this;
    }

    public List<StaticRoute> staticRoutes() {
        return this.staticRoutes;
    }

    public VnetRoute withStaticRoutes(List<StaticRoute> staticRoutes) {
        this.staticRoutes = staticRoutes;
        return this;
    }

    public List<SubResource> bgpConnections() {
        return this.bgpConnections;
    }

    public void validate() {
        if (this.staticRoutesConfig() != null) {
            this.staticRoutesConfig().validate();
        }
        if (this.staticRoutes() != null) {
            this.staticRoutes().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("staticRoutesConfig", this.staticRoutesConfig);
        jsonWriter.writeArrayField("staticRoutes", this.staticRoutes, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static VnetRoute fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VnetRoute deserializedVnetRoute = new VnetRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("staticRoutesConfig".equals(fieldName)) {
                    deserializedVnetRoute.staticRoutesConfig = StaticRoutesConfig.fromJson(reader);
                    continue;
                }
                if ("staticRoutes".equals(fieldName)) {
                    List<StaticRoute> staticRoutes = reader.readArray(reader1 -> StaticRoute.fromJson(reader1));
                    deserializedVnetRoute.staticRoutes = staticRoutes;
                    continue;
                }
                if ("bgpConnections".equals(fieldName)) {
                    List<SubResource> bgpConnections = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedVnetRoute.bgpConnections = bgpConnections;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVnetRoute;
        });
    }
}

