/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.VngClientConnectionConfigurationProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressSpace;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class VngClientConnectionConfiguration
extends SubResource {
    private VngClientConnectionConfigurationProperties innerProperties;
    private String name;
    private String etag;

    private VngClientConnectionConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public VngClientConnectionConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public VngClientConnectionConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    public AddressSpace vpnClientAddressPool() {
        return this.innerProperties() == null ? null : this.innerProperties().vpnClientAddressPool();
    }

    public VngClientConnectionConfiguration withVpnClientAddressPool(AddressSpace vpnClientAddressPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VngClientConnectionConfigurationProperties();
        }
        this.innerProperties().withVpnClientAddressPool(vpnClientAddressPool);
        return this;
    }

    public List<SubResource> virtualNetworkGatewayPolicyGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkGatewayPolicyGroups();
    }

    public VngClientConnectionConfiguration withVirtualNetworkGatewayPolicyGroups(List<SubResource> virtualNetworkGatewayPolicyGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VngClientConnectionConfigurationProperties();
        }
        this.innerProperties().withVirtualNetworkGatewayPolicyGroups(virtualNetworkGatewayPolicyGroups);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static VngClientConnectionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VngClientConnectionConfiguration deserializedVngClientConnectionConfiguration = new VngClientConnectionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVngClientConnectionConfiguration.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVngClientConnectionConfiguration.innerProperties = VngClientConnectionConfigurationProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVngClientConnectionConfiguration.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVngClientConnectionConfiguration.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVngClientConnectionConfiguration;
        });
    }
}

