/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayFirewallRateLimitDuration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.GroupByUserSession;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.MatchCondition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallRuleType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallState;
import java.io.IOException;
import java.util.List;

public final class WebApplicationFirewallCustomRule
implements JsonSerializable<WebApplicationFirewallCustomRule> {
    private String name;
    private String etag;
    private int priority;
    private WebApplicationFirewallState state;
    private ApplicationGatewayFirewallRateLimitDuration rateLimitDuration;
    private Integer rateLimitThreshold;
    private WebApplicationFirewallRuleType ruleType;
    private List<MatchCondition> matchConditions;
    private List<GroupByUserSession> groupByUserSession;
    private WebApplicationFirewallAction action;
    private static final ClientLogger LOGGER = new ClientLogger(WebApplicationFirewallCustomRule.class);

    public String name() {
        return this.name;
    }

    public WebApplicationFirewallCustomRule withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public int priority() {
        return this.priority;
    }

    public WebApplicationFirewallCustomRule withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public WebApplicationFirewallState state() {
        return this.state;
    }

    public WebApplicationFirewallCustomRule withState(WebApplicationFirewallState state) {
        this.state = state;
        return this;
    }

    public ApplicationGatewayFirewallRateLimitDuration rateLimitDuration() {
        return this.rateLimitDuration;
    }

    public WebApplicationFirewallCustomRule withRateLimitDuration(ApplicationGatewayFirewallRateLimitDuration rateLimitDuration) {
        this.rateLimitDuration = rateLimitDuration;
        return this;
    }

    public Integer rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    public WebApplicationFirewallCustomRule withRateLimitThreshold(Integer rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    public WebApplicationFirewallRuleType ruleType() {
        return this.ruleType;
    }

    public WebApplicationFirewallCustomRule withRuleType(WebApplicationFirewallRuleType ruleType) {
        this.ruleType = ruleType;
        return this;
    }

    public List<MatchCondition> matchConditions() {
        return this.matchConditions;
    }

    public WebApplicationFirewallCustomRule withMatchConditions(List<MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public List<GroupByUserSession> groupByUserSession() {
        return this.groupByUserSession;
    }

    public WebApplicationFirewallCustomRule withGroupByUserSession(List<GroupByUserSession> groupByUserSession) {
        this.groupByUserSession = groupByUserSession;
        return this;
    }

    public WebApplicationFirewallAction action() {
        return this.action;
    }

    public WebApplicationFirewallCustomRule withAction(WebApplicationFirewallAction action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.ruleType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property ruleType in model WebApplicationFirewallCustomRule"));
        }
        if (this.matchConditions() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property matchConditions in model WebApplicationFirewallCustomRule"));
        }
        this.matchConditions().forEach(e -> e.validate());
        if (this.groupByUserSession() != null) {
            this.groupByUserSession().forEach(e -> e.validate());
        }
        if (this.action() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property action in model WebApplicationFirewallCustomRule"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeArrayField("matchConditions", this.matchConditions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("rateLimitDuration", this.rateLimitDuration == null ? null : this.rateLimitDuration.toString());
        jsonWriter.writeNumberField("rateLimitThreshold", this.rateLimitThreshold);
        jsonWriter.writeArrayField("groupByUserSession", this.groupByUserSession, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static WebApplicationFirewallCustomRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebApplicationFirewallCustomRule deserializedWebApplicationFirewallCustomRule = new WebApplicationFirewallCustomRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("priority".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.priority = reader.getInt();
                    continue;
                }
                if ("ruleType".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.ruleType = WebApplicationFirewallRuleType.fromString(reader.getString());
                    continue;
                }
                if ("matchConditions".equals(fieldName)) {
                    List<MatchCondition> matchConditions = reader.readArray(reader1 -> MatchCondition.fromJson(reader1));
                    deserializedWebApplicationFirewallCustomRule.matchConditions = matchConditions;
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.action = WebApplicationFirewallAction.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.etag = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.state = WebApplicationFirewallState.fromString(reader.getString());
                    continue;
                }
                if ("rateLimitDuration".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.rateLimitDuration = ApplicationGatewayFirewallRateLimitDuration.fromString(reader.getString());
                    continue;
                }
                if ("rateLimitThreshold".equals(fieldName)) {
                    deserializedWebApplicationFirewallCustomRule.rateLimitThreshold = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("groupByUserSession".equals(fieldName)) {
                    List<GroupByUserSession> groupByUserSession = reader.readArray(reader1 -> GroupByUserSession.fromJson(reader1));
                    deserializedWebApplicationFirewallCustomRule.groupByUserSession = groupByUserSession;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebApplicationFirewallCustomRule;
        });
    }
}

