/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.RedisManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.RedisManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.PrivateEndpointConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.PrivateLinkResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisAccessKeysInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisFirewallRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisLinkedServerWithPropertiesInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisPatchScheduleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.RedisResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation.ConfigurationUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation.RedisAccessKeysImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation.RedisFirewallRuleImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation.RedisFirewallRulesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation.RedisPatchScheduleImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation.RedisPatchSchedulesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.DayOfWeek;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ExportRdbParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ImportRdbParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RebootType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisAccessKeys;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisCache;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisCachePremium;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisCreateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisFirewallRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisKeyType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisLinkedServerCreateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisRebootParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisRegenerateKeyParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.RedisUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ReplicationRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ScheduleEntry;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.Sku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.SkuFamily;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.SkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.TlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointConnectionProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateEndpointServiceConnectionStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.PrivateLinkServiceConnectionState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class RedisCacheImpl
extends GroupableResourceImpl<RedisCache, RedisResourceInner, RedisCacheImpl, RedisManager>
implements RedisCache,
RedisCachePremium,
RedisCache.Definition,
RedisCache.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private RedisAccessKeys cachedAccessKeys;
    private RedisCreateParameters createParameters = new RedisCreateParameters();
    private RedisUpdateParameters updateParameters;
    private RedisPatchSchedulesImpl patchSchedules = new RedisPatchSchedulesImpl(this);
    private RedisFirewallRulesImpl firewallRules = new RedisFirewallRulesImpl(this);
    private boolean patchScheduleAdded;

    RedisCacheImpl(String name, RedisResourceInner innerModel, RedisManager redisManager) {
        super(name, innerModel, redisManager);
        this.patchSchedules.enablePostRunMode();
        this.firewallRules.enablePostRunMode();
        this.patchScheduleAdded = false;
    }

    @Override
    public Map<String, RedisFirewallRule> firewallRules() {
        return this.firewallRules.rulesAsMap();
    }

    @Override
    public List<ScheduleEntry> patchSchedules() {
        List<ScheduleEntry> patchSchedules = this.listPatchSchedules();
        if (patchSchedules == null) {
            return new ArrayList<ScheduleEntry>();
        }
        return patchSchedules;
    }

    @Override
    public List<ScheduleEntry> listPatchSchedules() {
        RedisPatchScheduleImpl patchSchedule = this.patchSchedules.getPatchSchedule();
        if (patchSchedule == null) {
            return null;
        }
        return patchSchedule.scheduleEntries();
    }

    @Override
    public String provisioningState() {
        return ((RedisResourceInner)this.innerModel()).provisioningState().toString();
    }

    @Override
    public String hostname() {
        return ((RedisResourceInner)this.innerModel()).hostname();
    }

    @Override
    public int port() {
        return ResourceManagerUtils.toPrimitiveInt(((RedisResourceInner)this.innerModel()).port());
    }

    @Override
    public int sslPort() {
        return ResourceManagerUtils.toPrimitiveInt(((RedisResourceInner)this.innerModel()).sslPort());
    }

    @Override
    public String redisVersion() {
        return ((RedisResourceInner)this.innerModel()).redisVersion();
    }

    @Override
    public Sku sku() {
        return ((RedisResourceInner)this.innerModel()).sku();
    }

    @Override
    public boolean nonSslPort() {
        return ((RedisResourceInner)this.innerModel()).enableNonSslPort();
    }

    @Override
    public int shardCount() {
        return ResourceManagerUtils.toPrimitiveInt(((RedisResourceInner)this.innerModel()).shardCount());
    }

    @Override
    public String subnetId() {
        return ((RedisResourceInner)this.innerModel()).subnetId();
    }

    @Override
    public String staticIp() {
        return ((RedisResourceInner)this.innerModel()).staticIp();
    }

    @Override
    public TlsVersion minimumTlsVersion() {
        return ((RedisResourceInner)this.innerModel()).minimumTlsVersion();
    }

    @Override
    public Map<String, String> redisConfiguration() {
        return Collections.unmodifiableMap(ConfigurationUtils.toMap(((RedisResourceInner)this.innerModel()).redisConfiguration()));
    }

    @Override
    public RedisCachePremium asPremium() {
        if (this.isPremium()) {
            return this;
        }
        return null;
    }

    @Override
    public boolean isPremium() {
        return this.sku().name().equals(SkuName.PREMIUM);
    }

    @Override
    public RedisAccessKeys keys() {
        if (this.cachedAccessKeys == null) {
            this.cachedAccessKeys = this.refreshKeys();
        }
        return this.cachedAccessKeys;
    }

    @Override
    public RedisAccessKeys refreshKeys() {
        RedisAccessKeysInner response = ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().listKeys(this.resourceGroupName(), this.name());
        this.cachedAccessKeys = new RedisAccessKeysImpl(response);
        return this.cachedAccessKeys;
    }

    @Override
    public RedisAccessKeys regenerateKey(RedisKeyType keyType) {
        RedisAccessKeysInner response = ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().regenerateKey(this.resourceGroupName(), this.name(), new RedisRegenerateKeyParameters().withKeyType(keyType));
        this.cachedAccessKeys = new RedisAccessKeysImpl(response);
        return this.cachedAccessKeys;
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return ((RedisResourceInner)this.innerModel()).publicNetworkAccess();
    }

    @Override
    public void forceReboot(RebootType rebootType) {
        RedisRebootParameters parameters = new RedisRebootParameters().withRebootType(rebootType);
        ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().forceReboot(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void forceReboot(RebootType rebootType, int shardId) {
        RedisRebootParameters parameters = new RedisRebootParameters().withRebootType(rebootType).withShardId(shardId);
        ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().forceReboot(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void importData(List<String> files) {
        ImportRdbParameters parameters = new ImportRdbParameters().withFiles(files);
        ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().importData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void importData(List<String> files, String fileFormat) {
        ImportRdbParameters parameters = new ImportRdbParameters().withFiles(files).withFormat(fileFormat);
        ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().importData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void exportData(String containerSASUrl, String prefix) {
        ExportRdbParameters parameters = new ExportRdbParameters().withContainer(containerSASUrl).withPrefix(prefix);
        ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().exportData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public void exportData(String containerSASUrl, String prefix, String fileFormat) {
        ExportRdbParameters parameters = new ExportRdbParameters().withContainer(containerSASUrl).withPrefix(prefix).withFormat(fileFormat);
        ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().exportData(this.resourceGroupName(), this.name(), parameters);
    }

    @Override
    public RedisCacheImpl withNonSslPort() {
        if (this.isInCreateMode()) {
            this.createParameters.withEnableNonSslPort(true);
        } else {
            this.updateParameters.withEnableNonSslPort(true);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutNonSslPort() {
        if (!this.isInCreateMode()) {
            this.updateParameters.withEnableNonSslPort(false);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withRedisConfiguration(Map<String, String> redisConfiguration) {
        if (this.isInCreateMode()) {
            this.createParameters.withRedisConfiguration(ConfigurationUtils.toConfiguration(redisConfiguration));
        } else {
            this.updateParameters.withRedisConfiguration(ConfigurationUtils.toConfiguration(redisConfiguration));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withRedisConfiguration(String key, String value) {
        if (this.isInCreateMode()) {
            if (this.createParameters.redisConfiguration() == null) {
                this.createParameters.withRedisConfiguration(new RedisConfiguration());
            }
            ConfigurationUtils.putConfiguration(this.createParameters.redisConfiguration(), key, value);
        } else {
            if (this.updateParameters.redisConfiguration() == null) {
                this.updateParameters.withRedisConfiguration(new RedisConfiguration());
            }
            ConfigurationUtils.putConfiguration(this.updateParameters.redisConfiguration(), key, value);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withRedisConfiguration(RedisConfiguration redisConfiguration) {
        if (this.isInCreateMode()) {
            this.createParameters.withRedisConfiguration(redisConfiguration);
        } else {
            this.updateParameters.withRedisConfiguration(redisConfiguration);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withFirewallRule(String name, String lowestIp, String highestIp) {
        RedisFirewallRuleImpl rule = this.firewallRules.defineInlineFirewallRule(name);
        ((RedisFirewallRuleInner)rule.innerModel()).withStartIp(lowestIp);
        ((RedisFirewallRuleInner)rule.innerModel()).withEndIp(highestIp);
        return this.withFirewallRule(rule);
    }

    @Override
    public RedisCacheImpl withFirewallRule(RedisFirewallRule rule) {
        this.firewallRules.addRule((RedisFirewallRuleImpl)rule);
        return this;
    }

    @Override
    public RedisCacheImpl withMinimumTlsVersion(TlsVersion tlsVersion) {
        if (this.isInCreateMode()) {
            this.createParameters.withMinimumTlsVersion(tlsVersion);
        } else {
            this.updateParameters.withMinimumTlsVersion(tlsVersion);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutMinimumTlsVersion() {
        this.updateParameters.withMinimumTlsVersion(null);
        return this;
    }

    @Override
    public RedisCacheImpl withoutFirewallRule(String name) {
        this.firewallRules.removeRule(name);
        return this;
    }

    @Override
    public RedisCacheImpl withoutRedisConfiguration() {
        if (this.updateParameters.redisConfiguration() != null) {
            this.updateParameters.withRedisConfiguration(new RedisConfiguration());
        }
        return this;
    }

    @Override
    public RedisCacheImpl withoutRedisConfiguration(String key) {
        ConfigurationUtils.removeConfiguration(this.updateParameters.redisConfiguration(), key);
        return this;
    }

    @Override
    public RedisCacheImpl withSubnet(HasId networkResource, String subnetName) {
        if (networkResource != null) {
            String subnetId = networkResource.id() + "/subnets/" + subnetName;
            return this.withSubnet(subnetId);
        }
        this.createParameters.withSubnetId(null);
        return this;
    }

    @Override
    public RedisCacheImpl withSubnet(String subnetId) {
        if (subnetId != null) {
            if (this.isInCreateMode()) {
                this.createParameters.withSubnetId(subnetId);
            } else {
                throw this.logger.logExceptionAsError(new UnsupportedOperationException("Subnet cannot be modified during update operation."));
            }
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStaticIp(String staticIp) {
        if (!this.isInCreateMode()) {
            throw this.logger.logExceptionAsError(new UnsupportedOperationException("Static IP cannot be modified during update operation."));
        }
        this.createParameters.withStaticIp(staticIp);
        return this;
    }

    @Override
    public RedisCacheImpl withBasicSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withBasicSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.BASIC).withFamily(SkuFamily.C).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStandardSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withStandardSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.STANDARD).withFamily(SkuFamily.C).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPremiumSku() {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(1));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(1));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPremiumSku(int capacity) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(capacity));
        } else {
            this.updateParameters.withSku(new Sku().withName(SkuName.PREMIUM).withFamily(SkuFamily.P).withCapacity(capacity));
        }
        return this;
    }

    @Override
    public RedisCacheImpl withShardCount(int shardCount) {
        if (this.isInCreateMode()) {
            this.createParameters.withShardCount(shardCount);
        } else {
            this.updateParameters.withShardCount(shardCount);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPatchSchedule(DayOfWeek dayOfWeek, int startHourUtc) {
        return this.withPatchSchedule(new ScheduleEntry().withDayOfWeek(dayOfWeek).withStartHourUtc(startHourUtc));
    }

    @Override
    public RedisCacheImpl withPatchSchedule(DayOfWeek dayOfWeek, int startHourUtc, Duration maintenanceWindow) {
        return this.withPatchSchedule(new ScheduleEntry().withDayOfWeek(dayOfWeek).withStartHourUtc(startHourUtc).withMaintenanceWindow(maintenanceWindow));
    }

    @Override
    public RedisCacheImpl withPatchSchedule(List<ScheduleEntry> scheduleEntries) {
        this.patchSchedules.clear();
        for (ScheduleEntry entry : scheduleEntries) {
            this.withPatchSchedule(entry);
        }
        return this;
    }

    @Override
    public RedisCacheImpl withPatchSchedule(ScheduleEntry scheduleEntry) {
        RedisPatchScheduleImpl psch;
        if (this.patchSchedules.patchSchedulesAsMap().isEmpty()) {
            psch = this.patchSchedules.defineInlinePatchSchedule();
            this.patchScheduleAdded = true;
            ((RedisPatchScheduleInner)psch.innerModel()).withScheduleEntries(new ArrayList<ScheduleEntry>());
            this.patchSchedules.addPatchSchedule(psch);
        } else {
            psch = !this.patchScheduleAdded ? this.patchSchedules.updateInlinePatchSchedule() : this.patchSchedules.getPatchSchedule();
        }
        ((RedisPatchScheduleInner)psch.innerModel()).scheduleEntries().add(scheduleEntry);
        return this;
    }

    @Override
    public RedisCacheImpl withoutPatchSchedule() {
        if (this.patchSchedules.patchSchedulesAsMap().isEmpty()) {
            return this;
        }
        this.patchSchedules.deleteInlinePatchSchedule();
        return this;
    }

    @Override
    public RedisCacheImpl withRedisVersion(RedisCache.RedisVersion redisVersion) {
        String version;
        String string = version = redisVersion == null ? null : redisVersion.getValue();
        if (this.isInCreateMode()) {
            this.createParameters.withRedisVersion(version);
        } else {
            this.updateParameters.withRedisVersion(version);
        }
        return this;
    }

    @Override
    public void deletePatchSchedule() {
        this.patchSchedules.removePatchSchedule();
        this.patchSchedules.refresh();
    }

    @Override
    public Mono<RedisCache> refreshAsync() {
        return super.refreshAsync().then(this.firewallRules.refreshAsync()).then(this.patchSchedules.refreshAsync()).then(Mono.just(this));
    }

    @Override
    protected Mono<RedisResourceInner> getInnerAsync() {
        return ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.firewallRules.clear();
        this.patchSchedules.clear();
        this.patchScheduleAdded = false;
        if (isGroupFaulted) {
            return Mono.empty();
        }
        return this.refreshAsync().then();
    }

    @Override
    public RedisCacheImpl update() {
        this.updateParameters = new RedisUpdateParameters();
        this.patchSchedules.enableCommitMode();
        this.firewallRules.enableCommitMode();
        return (RedisCacheImpl)super.update();
    }

    @Override
    public Mono<RedisCache> updateResourceAsync() {
        this.updateParameters.withTags(((RedisResourceInner)this.innerModel()).tags());
        this.patchScheduleAdded = false;
        return ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap(this)).filter(redisCache -> !redisCache.provisioningState().equalsIgnoreCase(ProvisioningState.SUCCEEDED.toString())).flatMapMany(redisCache -> Mono.delay(ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getDefaultPollInterval())).flatMap(o -> ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().getByResourceGroupAsync(this.resourceGroupName(), this.name())).doOnNext(this::setInner).repeat().takeUntil(redisResourceInner -> redisResourceInner.provisioningState().toString().equalsIgnoreCase(ProvisioningState.SUCCEEDED.toString()))).then(this.patchSchedules.commitAndGetAllAsync()).then(this.firewallRules.commitAndGetAllAsync()).then(Mono.just(this));
    }

    @Override
    public Mono<RedisCache> createResourceAsync() {
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((RedisResourceInner)this.innerModel()).tags());
        if (CoreUtils.isNullOrEmpty(this.createParameters.redisVersion())) {
            this.withRedisVersion(RedisCache.RedisVersion.V6);
        }
        this.patchScheduleAdded = false;
        return ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().createAsync(this.resourceGroupName(), this.name(), this.createParameters).map(this.innerToFluentMap(this));
    }

    @Override
    public String addLinkedServer(String linkedRedisCacheId, String linkedServerLocation, ReplicationRole role) {
        String linkedRedisName = ResourceUtils.nameFromResourceId(linkedRedisCacheId);
        RedisLinkedServerCreateParameters params = new RedisLinkedServerCreateParameters().withLinkedRedisCacheId(linkedRedisCacheId).withLinkedRedisCacheLocation(linkedServerLocation).withServerRole(role);
        RedisLinkedServerWithPropertiesInner linkedServerInner = ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getLinkedServers().create(this.resourceGroupName(), this.name(), linkedRedisName, params);
        return linkedServerInner.name();
    }

    @Override
    public void removeLinkedServer(String linkedServerName) {
        RedisLinkedServerWithPropertiesInner linkedServer = ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getLinkedServers().get(this.resourceGroupName(), this.name(), linkedServerName);
        ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getLinkedServers().delete(this.resourceGroupName(), this.name(), linkedServerName);
        RedisResourceInner innerLinkedResource = null;
        RedisResourceInner innerResource = null;
        while (innerLinkedResource == null || innerLinkedResource.provisioningState() != ProvisioningState.SUCCEEDED || innerResource == null || innerResource.provisioningState() != ProvisioningState.SUCCEEDED) {
            ResourceManagerUtils.sleep(Duration.ofSeconds(30L));
            innerLinkedResource = ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().getByResourceGroup(ResourceUtils.groupFromResourceId(linkedServer.id()), ResourceUtils.nameFromResourceId(linkedServer.id()));
            innerResource = ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getRedis().getByResourceGroup(this.resourceGroupName(), this.name());
        }
    }

    @Override
    public ReplicationRole getLinkedServerRole(String linkedServerName) {
        RedisLinkedServerWithPropertiesInner linkedServer = ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getLinkedServers().get(this.resourceGroupName(), this.name(), linkedServerName);
        if (linkedServer == null) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Server returned `null` value for Linked Server '" + linkedServerName + "' for Redis Cache '" + this.name() + "' in Resource Group '" + this.resourceGroupName() + "'."));
        }
        return linkedServer.serverRole();
    }

    @Override
    public Map<String, ReplicationRole> listLinkedServers() {
        TreeMap<String, ReplicationRole> result = new TreeMap<String, ReplicationRole>();
        PagedIterable<RedisLinkedServerWithPropertiesInner> paginatedResponse = ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getLinkedServers().list(this.resourceGroupName(), this.name());
        for (RedisLinkedServerWithPropertiesInner linkedServer : paginatedResponse) {
            result.put(linkedServer.name(), linkedServer.serverRole());
        }
        return result;
    }

    @Override
    public PagedIterable<PrivateLinkResource> listPrivateLinkResources() {
        return new PagedIterable<PrivateLinkResource>(this.listPrivateLinkResourcesAsync());
    }

    @Override
    public PagedFlux<PrivateLinkResource> listPrivateLinkResourcesAsync() {
        return PagedConverter.mapPage(((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getPrivateLinkResources().listByRedisCacheAsync(this.resourceGroupName(), this.name()), x$0 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)x$0));
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> listPrivateEndpointConnections() {
        return new PagedIterable<PrivateEndpointConnection>(this.listPrivateEndpointConnectionsAsync());
    }

    @Override
    public PagedFlux<PrivateEndpointConnection> listPrivateEndpointConnectionsAsync() {
        return PagedConverter.mapPage(((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getPrivateEndpointConnections().listAsync(this.resourceGroupName(), this.name()), x$0 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)x$0));
    }

    @Override
    public void approvePrivateEndpointConnection(String privateEndpointConnectionName) {
        this.approvePrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    @Override
    public Mono<Void> approvePrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getPrivateEndpointConnections().putWithResponseAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PrivateLinkServiceConnectionState().withStatus(com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PrivateEndpointServiceConnectionStatus.APPROVED))).then();
    }

    @Override
    public void rejectPrivateEndpointConnection(String privateEndpointConnectionName) {
        this.rejectPrivateEndpointConnectionAsync(privateEndpointConnectionName).block();
    }

    @Override
    public Mono<Void> rejectPrivateEndpointConnectionAsync(String privateEndpointConnectionName) {
        return ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getPrivateEndpointConnections().putWithResponseAsync(this.resourceGroupName(), this.name(), privateEndpointConnectionName, new PrivateEndpointConnectionInner().withPrivateLinkServiceConnectionState(new com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PrivateLinkServiceConnectionState().withStatus(com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PrivateEndpointServiceConnectionStatus.REJECTED))).then();
    }

    @Override
    public RedisCacheImpl enablePublicNetworkAccess() {
        if (this.isInCreateMode()) {
            this.createParameters.withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        } else {
            this.updateParameters.withPublicNetworkAccess(PublicNetworkAccess.ENABLED);
        }
        return this;
    }

    @Override
    public RedisCacheImpl disablePublicNetworkAccess() {
        if (this.isInCreateMode()) {
            this.createParameters.withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        } else {
            this.updateParameters.withPublicNetworkAccess(PublicNetworkAccess.DISABLED);
        }
        return this;
    }

    private static final class PrivateEndpointConnectionImpl
    implements PrivateEndpointConnection {
        private final PrivateEndpointConnectionInner innerModel;
        private final PrivateEndpoint privateEndpoint;
        private final PrivateLinkServiceConnectionState privateLinkServiceConnectionState;
        private final PrivateEndpointConnectionProvisioningState provisioningState;

        private PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerModel) {
            this.innerModel = innerModel;
            PrivateEndpoint privateEndpoint = this.privateEndpoint = innerModel.privateEndpoint() == null ? null : new PrivateEndpoint(innerModel.privateEndpoint().id());
            this.privateLinkServiceConnectionState = innerModel.privateLinkServiceConnectionState() == null ? null : new PrivateLinkServiceConnectionState(innerModel.privateLinkServiceConnectionState().status() == null ? null : PrivateEndpointServiceConnectionStatus.fromString(innerModel.privateLinkServiceConnectionState().status().toString()), innerModel.privateLinkServiceConnectionState().description(), innerModel.privateLinkServiceConnectionState().actionsRequired());
            this.provisioningState = innerModel.provisioningState() == null ? null : PrivateEndpointConnectionProvisioningState.fromString(innerModel.provisioningState().toString());
        }

        @Override
        public String id() {
            return this.innerModel.id();
        }

        @Override
        public String name() {
            return this.innerModel.name();
        }

        @Override
        public String type() {
            return this.innerModel.type();
        }

        @Override
        public PrivateEndpoint privateEndpoint() {
            return this.privateEndpoint;
        }

        @Override
        public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
            return this.privateLinkServiceConnectionState;
        }

        @Override
        public PrivateEndpointConnectionProvisioningState provisioningState() {
            return this.provisioningState;
        }
    }

    private static final class PrivateLinkResourceImpl
    implements PrivateLinkResource {
        private final PrivateLinkResourceInner innerModel;

        private PrivateLinkResourceImpl(PrivateLinkResourceInner innerModel) {
            this.innerModel = innerModel;
        }

        @Override
        public String groupId() {
            return this.innerModel.groupId();
        }

        @Override
        public List<String> requiredMemberNames() {
            return Collections.unmodifiableList(this.innerModel.requiredMembers());
        }

        @Override
        public List<String> requiredDnsZoneNames() {
            return Collections.unmodifiableList(this.innerModel.requiredZoneNames());
        }
    }
}

