/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ParameterDefinitionsValue;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.PolicyDefinitionGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.PolicyDefinitionReference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.PolicyType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PolicySetDefinitionVersionProperties
implements JsonSerializable<PolicySetDefinitionVersionProperties> {
    private PolicyType policyType;
    private String displayName;
    private String description;
    private Object metadata;
    private Map<String, ParameterDefinitionsValue> parameters;
    private List<PolicyDefinitionReference> policyDefinitions;
    private List<PolicyDefinitionGroup> policyDefinitionGroups;
    private String version;
    private static final ClientLogger LOGGER = new ClientLogger(PolicySetDefinitionVersionProperties.class);

    public PolicyType policyType() {
        return this.policyType;
    }

    public PolicySetDefinitionVersionProperties withPolicyType(PolicyType policyType) {
        this.policyType = policyType;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public PolicySetDefinitionVersionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicySetDefinitionVersionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public PolicySetDefinitionVersionProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, ParameterDefinitionsValue> parameters() {
        return this.parameters;
    }

    public PolicySetDefinitionVersionProperties withParameters(Map<String, ParameterDefinitionsValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<PolicyDefinitionReference> policyDefinitions() {
        return this.policyDefinitions;
    }

    public PolicySetDefinitionVersionProperties withPolicyDefinitions(List<PolicyDefinitionReference> policyDefinitions) {
        this.policyDefinitions = policyDefinitions;
        return this;
    }

    public List<PolicyDefinitionGroup> policyDefinitionGroups() {
        return this.policyDefinitionGroups;
    }

    public PolicySetDefinitionVersionProperties withPolicyDefinitionGroups(List<PolicyDefinitionGroup> policyDefinitionGroups) {
        this.policyDefinitionGroups = policyDefinitionGroups;
        return this;
    }

    public String version() {
        return this.version;
    }

    public PolicySetDefinitionVersionProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.policyDefinitions() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property policyDefinitions in model PolicySetDefinitionVersionProperties"));
        }
        this.policyDefinitions().forEach(e -> e.validate());
        if (this.policyDefinitionGroups() != null) {
            this.policyDefinitionGroups().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("policyDefinitions", this.policyDefinitions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("policyType", this.policyType == null ? null : this.policyType.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("metadata", this.metadata);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("policyDefinitionGroups", this.policyDefinitionGroups, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("version", this.version);
        return jsonWriter.writeEndObject();
    }

    public static PolicySetDefinitionVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicySetDefinitionVersionProperties deserializedPolicySetDefinitionVersionProperties = new PolicySetDefinitionVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyDefinitions".equals(fieldName)) {
                    List<PolicyDefinitionReference> policyDefinitions = reader.readArray(reader1 -> PolicyDefinitionReference.fromJson(reader1));
                    deserializedPolicySetDefinitionVersionProperties.policyDefinitions = policyDefinitions;
                    continue;
                }
                if ("policyType".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionProperties.policyType = PolicyType.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionProperties.description = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionProperties.metadata = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map<String, ParameterDefinitionsValue> parameters = reader.readMap(reader1 -> ParameterDefinitionsValue.fromJson(reader1));
                    deserializedPolicySetDefinitionVersionProperties.parameters = parameters;
                    continue;
                }
                if ("policyDefinitionGroups".equals(fieldName)) {
                    List<PolicyDefinitionGroup> policyDefinitionGroups = reader.readArray(reader1 -> PolicyDefinitionGroup.fromJson(reader1));
                    deserializedPolicySetDefinitionVersionProperties.policyDefinitionGroups = policyDefinitionGroups;
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedPolicySetDefinitionVersionProperties.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicySetDefinitionVersionProperties;
        });
    }
}

