/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.dataiku.dss.shadelibazure.reactor.core.Exceptions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Sinks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public abstract class ExternalChildResourceCollectionImpl<FluentModelTImpl extends ExternalChildResourceImpl<FluentModelT, InnerModelT, ParentImplT, ParentT>, FluentModelT extends ExternalChildResource<FluentModelT, ParentT>, InnerModelT, ParentImplT extends ParentT, ParentT> {
    private final ParentImplT parent;
    private final TaskGroup parentTaskGroup;
    protected ConcurrentMap<String, FluentModelTImpl> childCollection = new ConcurrentSkipListMap<String, FluentModelTImpl>();
    private boolean isPostRunMode;
    protected final String childResourceName;

    protected ExternalChildResourceCollectionImpl(ParentImplT parent, TaskGroup parentTaskGroup, String childResourceName) {
        this.parent = parent;
        this.parentTaskGroup = parentTaskGroup;
        this.childResourceName = childResourceName;
        this.isPostRunMode = true;
    }

    public void enablePostRunMode() {
        this.isPostRunMode = true;
    }

    public void enableCommitMode() {
        this.isPostRunMode = false;
    }

    public void clear() {
        for (ExternalChildResourceImpl child : this.childCollection.values()) {
            child.clear();
        }
        this.childCollection.clear();
    }

    protected FluentModelTImpl prepareForFutureCommitOrPostRun(FluentModelTImpl childResource) {
        if (this.isPostRunMode && !((ExternalChildResourceImpl)childResource).taskGroup().dependsOn(this.parentTaskGroup)) {
            this.parentTaskGroup.addPostRunDependentTaskGroup(((ExternalChildResourceImpl)childResource).taskGroup());
        }
        return childResource;
    }

    public Flux<FluentModelTImpl> commitAsync() {
        if (this.isPostRunMode) {
            return Flux.error(new IllegalStateException("commitAsync() cannot be invoked when 'post run' mode is enabled"));
        }
        ExternalChildResourceCollectionImpl self = this;
        ArrayList<ExternalChildResourceImpl> items = new ArrayList<ExternalChildResourceImpl>();
        for (ExternalChildResourceImpl item : this.childCollection.values()) {
            items.add(item);
        }
        List exceptionsList = Collections.synchronizedList(new ArrayList());
        ArrayList successfullyRemoved = new ArrayList();
        Sinks.Many aggregatedErrorStream = Sinks.many().replay().all();
        Flux deleteStream = Flux.fromIterable(items).filter(childResource -> childResource.pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeRemoved).flatMap(childResource -> childResource.deleteResourceAsync().map(response -> childResource).doOnSuccess(fluentModelT -> {
            childResource.setPendingOperation(ExternalChildResourceImpl.PendingOperation.None);
            self.childCollection.remove(childResource.name());
            successfullyRemoved.add(childResource);
        }).onErrorResume(throwable -> {
            exceptionsList.add(throwable);
            return Mono.empty();
        }));
        Flux createStream = Flux.fromIterable(items).filter(childResource -> childResource.pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeCreated).flatMap(childResource -> childResource.createResourceAsync().map(fluentModelT -> childResource).doOnNext(fluentModelT -> childResource.setPendingOperation(ExternalChildResourceImpl.PendingOperation.None)).onErrorResume(throwable -> {
            self.childCollection.remove(childResource.name());
            exceptionsList.add(throwable);
            return Mono.empty();
        }));
        Flux updateStream = Flux.fromIterable(items).filter(childResource -> childResource.pendingOperation() == ExternalChildResourceImpl.PendingOperation.ToBeUpdated).flatMap(childResource -> childResource.updateResourceAsync().map(e -> childResource).doOnNext(resource -> resource.setPendingOperation(ExternalChildResourceImpl.PendingOperation.None)).onErrorResume(throwable -> {
            exceptionsList.add(throwable);
            return Mono.empty();
        }));
        Flux operationsStream = Flux.merge(deleteStream, createStream, updateStream).doOnTerminate(() -> {
            if (this.clearAfterCommit()) {
                self.childCollection.clear();
            }
            if (successfullyRemoved.size() > 0) {
                for (ExternalChildResourceImpl removed : successfullyRemoved) {
                    aggregatedErrorStream.tryEmitNext(removed);
                }
            }
            if (!exceptionsList.isEmpty()) {
                aggregatedErrorStream.tryEmitError(Exceptions.multiple(exceptionsList));
            } else {
                aggregatedErrorStream.tryEmitComplete();
            }
        });
        return Flux.concat(operationsStream, aggregatedErrorStream.asFlux());
    }

    public Mono<List<FluentModelTImpl>> commitAndGetAllAsync() {
        return this.commitAsync().collect(() -> new ArrayList(), (state, item) -> state.add(item));
    }

    protected FluentModelTImpl find(String key) {
        for (Map.Entry entry : this.childCollection.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(key)) continue;
            return (FluentModelTImpl)((ExternalChildResourceImpl)entry.getValue());
        }
        return null;
    }

    protected ParentImplT getParent() {
        return this.parent;
    }

    protected abstract boolean clearAfterCommit();
}

