/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.PolicySetDefinitionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.PolicyClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.PolicySetDefinitionListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class PolicySetDefinitionsClientImpl
implements PolicySetDefinitionsClient {
    private final PolicySetDefinitionsService service;
    private final PolicyClientImpl client;

    PolicySetDefinitionsClientImpl(PolicyClientImpl client) {
        this.service = RestProxy.create(PolicySetDefinitionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName, "2023-04-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> createOrUpdateWithResponseAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName, "2023-04-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> createOrUpdateAsync(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return this.createOrUpdateWithResponseAsync(policySetDefinitionName, parameters).flatMap(res -> Mono.justOrEmpty((PolicySetDefinitionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> createOrUpdateWithResponse(String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        return this.createOrUpdateWithResponseAsync(policySetDefinitionName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicySetDefinitionInner createOrUpdate(String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return this.createOrUpdateWithResponse(policySetDefinitionName, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String policySetDefinitionName) {
        return this.deleteWithResponseAsync(policySetDefinitionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String policySetDefinitionName, Context context) {
        return this.deleteWithResponseAsync(policySetDefinitionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String policySetDefinitionName) {
        this.deleteWithResponse(policySetDefinitionName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(String policySetDefinitionName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName, expand, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getWithResponseAsync(String policySetDefinitionName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName, expand, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getAsync(String policySetDefinitionName) {
        String expand = null;
        return this.getWithResponseAsync(policySetDefinitionName, expand).flatMap(res -> Mono.justOrEmpty((PolicySetDefinitionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getWithResponse(String policySetDefinitionName, String expand, Context context) {
        return this.getWithResponseAsync(policySetDefinitionName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicySetDefinitionInner get(String policySetDefinitionName) {
        String expand = null;
        return this.getWithResponse(policySetDefinitionName, expand, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBuiltIn(this.client.getEndpoint(), policySetDefinitionName, expand, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBuiltIn(this.client.getEndpoint(), policySetDefinitionName, expand, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getBuiltInAsync(String policySetDefinitionName) {
        String expand = null;
        return this.getBuiltInWithResponseAsync(policySetDefinitionName, expand).flatMap(res -> Mono.justOrEmpty((PolicySetDefinitionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getBuiltInWithResponse(String policySetDefinitionName, String expand, Context context) {
        return this.getBuiltInWithResponseAsync(policySetDefinitionName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicySetDefinitionInner getBuiltIn(String policySetDefinitionName) {
        String expand = null;
        return this.getBuiltInWithResponse(policySetDefinitionName, expand, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listSinglePageAsync(String filter, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2023-04-01", filter, expand, top, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listSinglePageAsync(String filter, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2023-04-01", filter, expand, top, "application/json", context).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listAsync(String filter, String expand, Integer top) {
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listSinglePageAsync(filter, expand, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listAsync() {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listSinglePageAsync(filter, expand, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listAsync(String filter, String expand, Integer top, Context context) {
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listSinglePageAsync(filter, expand, top, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> list() {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedIterable<PolicySetDefinitionInner>(this.listAsync(filter, expand, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> list(String filter, String expand, Integer top, Context context) {
        return new PagedIterable<PolicySetDefinitionInner>(this.listAsync(filter, expand, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInSinglePageAsync(String filter, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuiltIn(this.client.getEndpoint(), "2023-04-01", filter, expand, top, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInSinglePageAsync(String filter, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuiltIn(this.client.getEndpoint(), "2023-04-01", filter, expand, top, "application/json", context).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listBuiltInAsync(String filter, String expand, Integer top) {
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listBuiltInSinglePageAsync(filter, expand, top), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listBuiltInAsync() {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listBuiltInSinglePageAsync(filter, expand, top), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listBuiltInAsync(String filter, String expand, Integer top, Context context) {
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listBuiltInSinglePageAsync(filter, expand, top, context), nextLink -> this.listBuiltInNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listBuiltIn() {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedIterable<PolicySetDefinitionInner>(this.listBuiltInAsync(filter, expand, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listBuiltIn(String filter, String expand, Integer top, Context context) {
        return new PagedIterable<PolicySetDefinitionInner>(this.listBuiltInAsync(filter, expand, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupId, String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), managementGroupId, policySetDefinitionName, "2023-04-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroupWithResponseAsync(String managementGroupId, String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), managementGroupId, policySetDefinitionName, "2023-04-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> createOrUpdateAtManagementGroupAsync(String managementGroupId, String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithResponseAsync(managementGroupId, policySetDefinitionName, parameters).flatMap(res -> Mono.justOrEmpty((PolicySetDefinitionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> createOrUpdateAtManagementGroupWithResponse(String managementGroupId, String policySetDefinitionName, PolicySetDefinitionInner parameters, Context context) {
        return this.createOrUpdateAtManagementGroupWithResponseAsync(managementGroupId, policySetDefinitionName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicySetDefinitionInner createOrUpdateAtManagementGroup(String managementGroupId, String policySetDefinitionName, PolicySetDefinitionInner parameters) {
        return this.createOrUpdateAtManagementGroupWithResponse(managementGroupId, policySetDefinitionName, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String managementGroupId, String policySetDefinitionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAtManagementGroup(this.client.getEndpoint(), managementGroupId, policySetDefinitionName, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String managementGroupId, String policySetDefinitionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAtManagementGroup(this.client.getEndpoint(), managementGroupId, policySetDefinitionName, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupAsync(String managementGroupId, String policySetDefinitionName) {
        return this.deleteAtManagementGroupWithResponseAsync(managementGroupId, policySetDefinitionName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteAtManagementGroupWithResponse(String managementGroupId, String policySetDefinitionName, Context context) {
        return this.deleteAtManagementGroupWithResponseAsync(managementGroupId, policySetDefinitionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteAtManagementGroup(String managementGroupId, String policySetDefinitionName) {
        this.deleteAtManagementGroupWithResponse(managementGroupId, policySetDefinitionName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(String managementGroupId, String policySetDefinitionName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAtManagementGroup(this.client.getEndpoint(), managementGroupId, policySetDefinitionName, expand, "2023-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionInner>> getAtManagementGroupWithResponseAsync(String managementGroupId, String policySetDefinitionName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAtManagementGroup(this.client.getEndpoint(), managementGroupId, policySetDefinitionName, expand, "2023-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PolicySetDefinitionInner> getAtManagementGroupAsync(String managementGroupId, String policySetDefinitionName) {
        String expand = null;
        return this.getAtManagementGroupWithResponseAsync(managementGroupId, policySetDefinitionName, expand).flatMap(res -> Mono.justOrEmpty((PolicySetDefinitionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PolicySetDefinitionInner> getAtManagementGroupWithResponse(String managementGroupId, String policySetDefinitionName, String expand, Context context) {
        return this.getAtManagementGroupWithResponseAsync(managementGroupId, policySetDefinitionName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PolicySetDefinitionInner getAtManagementGroup(String managementGroupId, String policySetDefinitionName) {
        String expand = null;
        return this.getAtManagementGroupWithResponse(managementGroupId, policySetDefinitionName, expand, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupSinglePageAsync(String managementGroupId, String filter, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByManagementGroup(this.client.getEndpoint(), managementGroupId, "2023-04-01", filter, expand, top, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupSinglePageAsync(String managementGroupId, String filter, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupId == null) {
            return Mono.error(new IllegalArgumentException("Parameter managementGroupId is required and cannot be null."));
        }
        String apiVersion = "2023-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroup(this.client.getEndpoint(), managementGroupId, "2023-04-01", filter, expand, top, "application/json", context).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId, String filter, String expand, Integer top) {
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listByManagementGroupSinglePageAsync(managementGroupId, filter, expand, top), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId) {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listByManagementGroupSinglePageAsync(managementGroupId, filter, expand, top), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionInner> listByManagementGroupAsync(String managementGroupId, String filter, String expand, Integer top, Context context) {
        return new PagedFlux<PolicySetDefinitionInner>(() -> this.listByManagementGroupSinglePageAsync(managementGroupId, filter, expand, top, context), nextLink -> this.listByManagementGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId) {
        String filter = null;
        String expand = null;
        Integer top = null;
        return new PagedIterable<PolicySetDefinitionInner>(this.listByManagementGroupAsync(managementGroupId, filter, expand, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionInner> listByManagementGroup(String managementGroupId, String filter, String expand, Integer top, Context context) {
        return new PagedIterable<PolicySetDefinitionInner>(this.listByManagementGroupAsync(managementGroupId, filter, expand, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBuiltInNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listBuiltInNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBuiltInNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionInner>> listByManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, PolicySetDefinitionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PolicySetDefinitionListResult)res.getValue()).value(), ((PolicySetDefinitionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PolicyClientPolicySe")
    public static interface PolicySetDefinitionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="policySetDefinitionName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") PolicySetDefinitionInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="policySetDefinitionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="policySetDefinitionName") String var3, @QueryParam(value="$expand") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> getBuiltIn(@HostParam(value="$host") String var1, @PathParam(value="policySetDefinitionName") String var2, @QueryParam(value="$expand") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$filter", encoded=true) String var4, @QueryParam(value="$expand") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listBuiltIn(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="$filter", encoded=true) String var3, @QueryParam(value="$expand") String var4, @QueryParam(value="$top") Integer var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> createOrUpdateAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="policySetDefinitionName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") PolicySetDefinitionInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> deleteAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="policySetDefinitionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionInner>> getAtManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @PathParam(value="policySetDefinitionName") String var3, @QueryParam(value="$expand") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/policySetDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listByManagementGroup(@HostParam(value="$host") String var1, @PathParam(value="managementGroupId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="$filter", encoded=true) String var4, @QueryParam(value="$expand") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listBuiltInNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PolicySetDefinitionListResult>> listByManagementGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

