/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.ResourceNamesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.CheckResourceNameResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.SubscriptionClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceName;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class ResourceNamesClientImpl
implements ResourceNamesClient {
    private final ResourceNamesService service;
    private final SubscriptionClientImpl client;

    ResourceNamesClientImpl(SubscriptionClientImpl client) {
        this.service = RestProxy.create(ResourceNamesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CheckResourceNameResultInner>> checkResourceNameWithResponseAsync(ResourceName resourceNameDefinition) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceNameDefinition != null) {
            resourceNameDefinition.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkResourceName(this.client.getEndpoint(), this.client.getApiVersion(), resourceNameDefinition, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckResourceNameResultInner>> checkResourceNameWithResponseAsync(ResourceName resourceNameDefinition, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceNameDefinition != null) {
            resourceNameDefinition.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkResourceName(this.client.getEndpoint(), this.client.getApiVersion(), resourceNameDefinition, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckResourceNameResultInner> checkResourceNameAsync() {
        ResourceName resourceNameDefinition = null;
        return this.checkResourceNameWithResponseAsync(resourceNameDefinition).flatMap(res -> Mono.justOrEmpty((CheckResourceNameResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckResourceNameResultInner> checkResourceNameWithResponse(ResourceName resourceNameDefinition, Context context) {
        return this.checkResourceNameWithResponseAsync(resourceNameDefinition, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckResourceNameResultInner checkResourceName() {
        ResourceName resourceNameDefinition = null;
        return this.checkResourceNameWithResponse(resourceNameDefinition, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SubscriptionClientRe")
    public static interface ResourceNamesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Resources/checkResourceName")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckResourceNameResultInner>> checkResourceName(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ResourceName var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

