/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.AliasPath;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.AliasPathMetadata;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.AliasPattern;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.AliasType;
import java.io.IOException;
import java.util.List;

public final class Alias
implements JsonSerializable<Alias> {
    private String name;
    private List<AliasPath> paths;
    private AliasType type;
    private String defaultPath;
    private AliasPattern defaultPattern;
    private AliasPathMetadata defaultMetadata;

    public String name() {
        return this.name;
    }

    public Alias withName(String name) {
        this.name = name;
        return this;
    }

    public List<AliasPath> paths() {
        return this.paths;
    }

    public Alias withPaths(List<AliasPath> paths) {
        this.paths = paths;
        return this;
    }

    public AliasType type() {
        return this.type;
    }

    public Alias withType(AliasType type) {
        this.type = type;
        return this;
    }

    public String defaultPath() {
        return this.defaultPath;
    }

    public Alias withDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
        return this;
    }

    public AliasPattern defaultPattern() {
        return this.defaultPattern;
    }

    public Alias withDefaultPattern(AliasPattern defaultPattern) {
        this.defaultPattern = defaultPattern;
        return this;
    }

    public AliasPathMetadata defaultMetadata() {
        return this.defaultMetadata;
    }

    public void validate() {
        if (this.paths() != null) {
            this.paths().forEach(e -> e.validate());
        }
        if (this.defaultPattern() != null) {
            this.defaultPattern().validate();
        }
        if (this.defaultMetadata() != null) {
            this.defaultMetadata().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("paths", this.paths, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("defaultPath", this.defaultPath);
        jsonWriter.writeJsonField("defaultPattern", this.defaultPattern);
        return jsonWriter.writeEndObject();
    }

    public static Alias fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Alias deserializedAlias = new Alias();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAlias.name = reader.getString();
                    continue;
                }
                if ("paths".equals(fieldName)) {
                    List<AliasPath> paths = reader.readArray(reader1 -> AliasPath.fromJson(reader1));
                    deserializedAlias.paths = paths;
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAlias.type = AliasType.fromString(reader.getString());
                    continue;
                }
                if ("defaultPath".equals(fieldName)) {
                    deserializedAlias.defaultPath = reader.getString();
                    continue;
                }
                if ("defaultPattern".equals(fieldName)) {
                    deserializedAlias.defaultPattern = AliasPattern.fromJson(reader);
                    continue;
                }
                if ("defaultMetadata".equals(fieldName)) {
                    deserializedAlias.defaultMetadata = AliasPathMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAlias;
        });
    }
}

