/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.Alias;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ApiProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ProviderExtendedLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ZoneMapping;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ProviderResourceType
implements JsonSerializable<ProviderResourceType> {
    private String resourceType;
    private List<String> locations;
    private List<ProviderExtendedLocation> locationMappings;
    private List<Alias> aliases;
    private List<String> apiVersions;
    private String defaultApiVersion;
    private List<ZoneMapping> zoneMappings;
    private List<ApiProfile> apiProfiles;
    private String capabilities;
    private Map<String, String> properties;

    public String resourceType() {
        return this.resourceType;
    }

    public ProviderResourceType withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public ProviderResourceType withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<ProviderExtendedLocation> locationMappings() {
        return this.locationMappings;
    }

    public ProviderResourceType withLocationMappings(List<ProviderExtendedLocation> locationMappings) {
        this.locationMappings = locationMappings;
        return this;
    }

    public List<Alias> aliases() {
        return this.aliases;
    }

    public ProviderResourceType withAliases(List<Alias> aliases) {
        this.aliases = aliases;
        return this;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public ProviderResourceType withApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public String defaultApiVersion() {
        return this.defaultApiVersion;
    }

    public List<ZoneMapping> zoneMappings() {
        return this.zoneMappings;
    }

    public ProviderResourceType withZoneMappings(List<ZoneMapping> zoneMappings) {
        this.zoneMappings = zoneMappings;
        return this;
    }

    public List<ApiProfile> apiProfiles() {
        return this.apiProfiles;
    }

    public String capabilities() {
        return this.capabilities;
    }

    public ProviderResourceType withCapabilities(String capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public ProviderResourceType withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.locationMappings() != null) {
            this.locationMappings().forEach(e -> e.validate());
        }
        if (this.aliases() != null) {
            this.aliases().forEach(e -> e.validate());
        }
        if (this.zoneMappings() != null) {
            this.zoneMappings().forEach(e -> e.validate());
        }
        if (this.apiProfiles() != null) {
            this.apiProfiles().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("locationMappings", this.locationMappings, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("aliases", this.aliases, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("apiVersions", this.apiVersions, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("zoneMappings", this.zoneMappings, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("capabilities", this.capabilities);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static ProviderResourceType fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderResourceType deserializedProviderResourceType = new ProviderResourceType();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedProviderResourceType.resourceType = reader.getString();
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedProviderResourceType.locations = locations;
                    continue;
                }
                if ("locationMappings".equals(fieldName)) {
                    List<ProviderExtendedLocation> locationMappings = reader.readArray(reader1 -> ProviderExtendedLocation.fromJson(reader1));
                    deserializedProviderResourceType.locationMappings = locationMappings;
                    continue;
                }
                if ("aliases".equals(fieldName)) {
                    List<Alias> aliases = reader.readArray(reader1 -> Alias.fromJson(reader1));
                    deserializedProviderResourceType.aliases = aliases;
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List<String> apiVersions = reader.readArray(reader1 -> reader1.getString());
                    deserializedProviderResourceType.apiVersions = apiVersions;
                    continue;
                }
                if ("defaultApiVersion".equals(fieldName)) {
                    deserializedProviderResourceType.defaultApiVersion = reader.getString();
                    continue;
                }
                if ("zoneMappings".equals(fieldName)) {
                    List<ZoneMapping> zoneMappings = reader.readArray(reader1 -> ZoneMapping.fromJson(reader1));
                    deserializedProviderResourceType.zoneMappings = zoneMappings;
                    continue;
                }
                if ("apiProfiles".equals(fieldName)) {
                    List<ApiProfile> apiProfiles = reader.readArray(reader1 -> ApiProfile.fromJson(reader1));
                    deserializedProviderResourceType.apiProfiles = apiProfiles;
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    deserializedProviderResourceType.capabilities = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map<String, String> properties = reader.readMap(reader1 -> reader1.getString());
                    deserializedProviderResourceType.properties = properties;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProviderResourceType;
        });
    }
}

