/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.DeploymentProperties;
import java.io.IOException;
import java.util.Map;

public final class ScopedDeployment
implements JsonSerializable<ScopedDeployment> {
    private String location;
    private DeploymentProperties properties;
    private Map<String, String> tags;
    private static final ClientLogger LOGGER = new ClientLogger(ScopedDeployment.class);

    public String location() {
        return this.location;
    }

    public ScopedDeployment withLocation(String location) {
        this.location = location;
        return this;
    }

    public DeploymentProperties properties() {
        return this.properties;
    }

    public ScopedDeployment withProperties(DeploymentProperties properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ScopedDeployment withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property location in model ScopedDeployment"));
        }
        if (this.properties() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property properties in model ScopedDeployment"));
        }
        this.properties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static ScopedDeployment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopedDeployment deserializedScopedDeployment = new ScopedDeployment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedScopedDeployment.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScopedDeployment.properties = DeploymentProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedScopedDeployment.tags = tags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScopedDeployment;
        });
    }
}

