/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.AuthorizationProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.SubscriptionFeatureRegistrationApprovalType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.SubscriptionFeatureRegistrationState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class SubscriptionFeatureRegistrationProperties
implements JsonSerializable<SubscriptionFeatureRegistrationProperties> {
    private String tenantId;
    private String subscriptionId;
    private String featureName;
    private String displayName;
    private String providerNamespace;
    private SubscriptionFeatureRegistrationState state;
    private AuthorizationProfile authorizationProfile;
    private Map<String, String> metadata;
    private OffsetDateTime releaseDate;
    private OffsetDateTime registrationDate;
    private String documentationLink;
    private SubscriptionFeatureRegistrationApprovalType approvalType;
    private Boolean shouldFeatureDisplayInPortal;
    private String description;

    public String tenantId() {
        return this.tenantId;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String featureName() {
        return this.featureName;
    }

    public String displayName() {
        return this.displayName;
    }

    public String providerNamespace() {
        return this.providerNamespace;
    }

    public SubscriptionFeatureRegistrationState state() {
        return this.state;
    }

    public SubscriptionFeatureRegistrationProperties withState(SubscriptionFeatureRegistrationState state) {
        this.state = state;
        return this;
    }

    public AuthorizationProfile authorizationProfile() {
        return this.authorizationProfile;
    }

    public SubscriptionFeatureRegistrationProperties withAuthorizationProfile(AuthorizationProfile authorizationProfile) {
        this.authorizationProfile = authorizationProfile;
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public SubscriptionFeatureRegistrationProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public OffsetDateTime releaseDate() {
        return this.releaseDate;
    }

    public OffsetDateTime registrationDate() {
        return this.registrationDate;
    }

    public String documentationLink() {
        return this.documentationLink;
    }

    public SubscriptionFeatureRegistrationApprovalType approvalType() {
        return this.approvalType;
    }

    public Boolean shouldFeatureDisplayInPortal() {
        return this.shouldFeatureDisplayInPortal;
    }

    public SubscriptionFeatureRegistrationProperties withShouldFeatureDisplayInPortal(Boolean shouldFeatureDisplayInPortal) {
        this.shouldFeatureDisplayInPortal = shouldFeatureDisplayInPortal;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SubscriptionFeatureRegistrationProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.authorizationProfile() != null) {
            this.authorizationProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("authorizationProfile", this.authorizationProfile);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("shouldFeatureDisplayInPortal", this.shouldFeatureDisplayInPortal);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionFeatureRegistrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionFeatureRegistrationProperties deserializedSubscriptionFeatureRegistrationProperties = new SubscriptionFeatureRegistrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.tenantId = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.subscriptionId = reader.getString();
                    continue;
                }
                if ("featureName".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.featureName = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.displayName = reader.getString();
                    continue;
                }
                if ("providerNamespace".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.providerNamespace = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.state = SubscriptionFeatureRegistrationState.fromString(reader.getString());
                    continue;
                }
                if ("authorizationProfile".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.authorizationProfile = AuthorizationProfile.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedSubscriptionFeatureRegistrationProperties.metadata = metadata;
                    continue;
                }
                if ("releaseDate".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.releaseDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("registrationDate".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.registrationDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("documentationLink".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.documentationLink = reader.getString();
                    continue;
                }
                if ("approvalType".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.approvalType = SubscriptionFeatureRegistrationApprovalType.fromString(reader.getString());
                    continue;
                }
                if ("shouldFeatureDisplayInPortal".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.shouldFeatureDisplayInPortal = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSubscriptionFeatureRegistrationProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionFeatureRegistrationProperties;
        });
    }
}

