/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.AdminKeysClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.AdminKeyResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.SearchManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.AdminKeyKind;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.UUID;

public final class AdminKeysClientImpl
implements AdminKeysClient {
    private final AdminKeysService service;
    private final SearchManagementClientImpl client;

    AdminKeysClientImpl(SearchManagementClientImpl client) {
        this.service = RestProxy.create(AdminKeysService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AdminKeyResultInner>> getWithResponseAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdminKeyResultInner>> getWithResponseAsync(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AdminKeyResultInner> getAsync(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return this.getWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId).flatMap(res -> Mono.justOrEmpty((AdminKeyResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdminKeyResultInner> getWithResponse(String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return this.getWithResponseAsync(resourceGroupName, searchServiceName, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdminKeyResultInner get(String resourceGroupName, String searchServiceName) {
        UUID clientRequestId = null;
        return this.getWithResponse(resourceGroupName, searchServiceName, clientRequestId, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AdminKeyResultInner>> regenerateWithResponseAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (keyKind == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyKind is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regenerate(this.client.getEndpoint(), resourceGroupName, searchServiceName, keyKind, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdminKeyResultInner>> regenerateWithResponseAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (keyKind == null) {
            return Mono.error(new IllegalArgumentException("Parameter keyKind is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.regenerate(this.client.getEndpoint(), resourceGroupName, searchServiceName, keyKind, clientRequestId, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AdminKeyResultInner> regenerateAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        UUID clientRequestId = null;
        return this.regenerateWithResponseAsync(resourceGroupName, searchServiceName, keyKind, clientRequestId).flatMap(res -> Mono.justOrEmpty((AdminKeyResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdminKeyResultInner> regenerateWithResponse(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind, UUID clientRequestId, Context context) {
        return this.regenerateWithResponseAsync(resourceGroupName, searchServiceName, keyKind, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdminKeyResultInner regenerate(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        UUID clientRequestId = null;
        return this.regenerateWithResponse(resourceGroupName, searchServiceName, keyKind, clientRequestId, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SearchManagementClie")
    public static interface AdminKeysService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/listAdminKeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdminKeyResultInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @HeaderParam(value="x-ms-client-request-id") UUID var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/regenerateAdminKey/{keyKind}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdminKeyResultInner>> regenerate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="searchServiceName") String var3, @PathParam(value="keyKind") AdminKeyKind var4, @HeaderParam(value="x-ms-client-request-id") UUID var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

