/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.AzureEnvironment;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.AdminKeysClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.OperationsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.PrivateEndpointConnectionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.PrivateLinkResourcesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.QueryKeysClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.SearchManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.ServicesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.SharedPrivateLinkResourcesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.UsagesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.QuotaUsageResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.AdminKeysClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.OperationsClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.PrivateEndpointConnectionsClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.PrivateLinkResourcesClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.QueryKeysClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.SearchManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.ServicesClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.SharedPrivateLinkResourcesClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.UsagesClientImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.util.UUID;

@ServiceClient(builder=SearchManagementClientBuilder.class)
public final class SearchManagementClientImpl
extends AzureServiceClient
implements SearchManagementClient {
    private final SearchManagementClientService service;
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final AdminKeysClient adminKeys;
    private final QueryKeysClient queryKeys;
    private final ServicesClient services;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final SharedPrivateLinkResourcesClient sharedPrivateLinkResources;
    private final UsagesClient usages;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public AdminKeysClient getAdminKeys() {
        return this.adminKeys;
    }

    @Override
    public QueryKeysClient getQueryKeys() {
        return this.queryKeys;
    }

    @Override
    public ServicesClient getServices() {
        return this.services;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public SharedPrivateLinkResourcesClient getSharedPrivateLinkResources() {
        return this.sharedPrivateLinkResources;
    }

    @Override
    public UsagesClient getUsages() {
        return this.usages;
    }

    SearchManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2023-11-01";
        this.operations = new OperationsClientImpl(this);
        this.adminKeys = new AdminKeysClientImpl(this);
        this.queryKeys = new QueryKeysClientImpl(this);
        this.services = new ServicesClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.sharedPrivateLinkResources = new SharedPrivateLinkResourcesClientImpl(this);
        this.usages = new UsagesClientImpl(this);
        this.service = RestProxy.create(SearchManagementClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QuotaUsageResultInner>> usageBySubscriptionSkuWithResponseAsync(String location, String skuName, UUID clientRequestId) {
        if (this.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (skuName == null) {
            return Mono.error(new IllegalArgumentException("Parameter skuName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.usageBySubscriptionSku(this.getEndpoint(), clientRequestId, location, this.getApiVersion(), this.getSubscriptionId(), skuName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QuotaUsageResultInner>> usageBySubscriptionSkuWithResponseAsync(String location, String skuName, UUID clientRequestId, Context context) {
        if (this.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.getSubscriptionId() is required and cannot be null."));
        }
        if (skuName == null) {
            return Mono.error(new IllegalArgumentException("Parameter skuName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.mergeContext(context);
        return this.service.usageBySubscriptionSku(this.getEndpoint(), clientRequestId, location, this.getApiVersion(), this.getSubscriptionId(), skuName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QuotaUsageResultInner> usageBySubscriptionSkuAsync(String location, String skuName) {
        UUID clientRequestId = null;
        return this.usageBySubscriptionSkuWithResponseAsync(location, skuName, clientRequestId).flatMap(res -> Mono.justOrEmpty((QuotaUsageResultInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QuotaUsageResultInner> usageBySubscriptionSkuWithResponse(String location, String skuName, UUID clientRequestId, Context context) {
        return this.usageBySubscriptionSkuWithResponseAsync(location, skuName, clientRequestId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QuotaUsageResultInner usageBySubscriptionSku(String location, String skuName) {
        UUID clientRequestId = null;
        return this.usageBySubscriptionSkuWithResponse(location, skuName, clientRequestId, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SearchManagementClie")
    public static interface SearchManagementClientService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Search/locations/{location}/usages/{skuName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QuotaUsageResultInner>> usageBySubscriptionSku(@HostParam(value="$host") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="skuName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

