/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServersImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServers;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.StorageManager;
import java.util.Objects;

public class SqlServerManager
extends Manager<SqlManagementClient> {
    private SqlServers sqlServers;
    private final String tenantId;
    private final StorageManager storageManager;

    protected SqlServerManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new SqlManagementClientBuilder().pipeline(httpPipeline).subscriptionId(profile.getSubscriptionId()).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).buildClient());
        this.storageManager = StorageManager.authenticate(httpPipeline, profile);
        this.tenantId = profile.getTenantId();
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static SqlServerManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return SqlServerManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static SqlServerManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new SqlServerManager(httpPipeline, profile);
    }

    public SqlServers sqlServers() {
        if (this.sqlServers == null) {
            this.sqlServers = new SqlServersImpl(this);
        }
        return this.sqlServers;
    }

    public String tenantId() {
        return this.tenantId;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public SqlServerManager authenticate(TokenCredential credential, AzureProfile profile) {
            return SqlServerManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public SqlServerManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

