/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.FailoverGroupReadOnlyEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.FailoverGroupReadWriteEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.FailoverGroupReplicationRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.PartnerInfo;
import java.io.IOException;
import java.util.List;

public final class FailoverGroupProperties
implements JsonSerializable<FailoverGroupProperties> {
    private FailoverGroupReadWriteEndpoint readWriteEndpoint;
    private FailoverGroupReadOnlyEndpoint readOnlyEndpoint;
    private FailoverGroupReplicationRole replicationRole;
    private String replicationState;
    private List<PartnerInfo> partnerServers;
    private List<String> databases;
    private static final ClientLogger LOGGER = new ClientLogger(FailoverGroupProperties.class);

    public FailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    public FailoverGroupProperties withReadWriteEndpoint(FailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    public FailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    public FailoverGroupProperties withReadOnlyEndpoint(FailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    public FailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public String replicationState() {
        return this.replicationState;
    }

    public List<PartnerInfo> partnerServers() {
        return this.partnerServers;
    }

    public FailoverGroupProperties withPartnerServers(List<PartnerInfo> partnerServers) {
        this.partnerServers = partnerServers;
        return this;
    }

    public List<String> databases() {
        return this.databases;
    }

    public FailoverGroupProperties withDatabases(List<String> databases) {
        this.databases = databases;
        return this;
    }

    public void validate() {
        if (this.readWriteEndpoint() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property readWriteEndpoint in model FailoverGroupProperties"));
        }
        this.readWriteEndpoint().validate();
        if (this.readOnlyEndpoint() != null) {
            this.readOnlyEndpoint().validate();
        }
        if (this.partnerServers() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property partnerServers in model FailoverGroupProperties"));
        }
        this.partnerServers().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("readWriteEndpoint", this.readWriteEndpoint);
        jsonWriter.writeArrayField("partnerServers", this.partnerServers, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeJsonField("readOnlyEndpoint", this.readOnlyEndpoint);
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static FailoverGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FailoverGroupProperties deserializedFailoverGroupProperties = new FailoverGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("readWriteEndpoint".equals(fieldName)) {
                    deserializedFailoverGroupProperties.readWriteEndpoint = FailoverGroupReadWriteEndpoint.fromJson(reader);
                    continue;
                }
                if ("partnerServers".equals(fieldName)) {
                    List<PartnerInfo> partnerServers = reader.readArray(reader1 -> PartnerInfo.fromJson(reader1));
                    deserializedFailoverGroupProperties.partnerServers = partnerServers;
                    continue;
                }
                if ("readOnlyEndpoint".equals(fieldName)) {
                    deserializedFailoverGroupProperties.readOnlyEndpoint = FailoverGroupReadOnlyEndpoint.fromJson(reader);
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedFailoverGroupProperties.replicationRole = FailoverGroupReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("replicationState".equals(fieldName)) {
                    deserializedFailoverGroupProperties.replicationState = reader.getString();
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List<String> databases = reader.readArray(reader1 -> reader1.getString());
                    deserializedFailoverGroupProperties.databases = databases;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFailoverGroupProperties;
        });
    }
}

