/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerKeyType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ManagedInstanceKeyProperties
implements JsonSerializable<ManagedInstanceKeyProperties> {
    private ServerKeyType serverKeyType;
    private String uri;
    private String thumbprint;
    private OffsetDateTime creationDate;
    private Boolean autoRotationEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedInstanceKeyProperties.class);

    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    public ManagedInstanceKeyProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ManagedInstanceKeyProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public Boolean autoRotationEnabled() {
        return this.autoRotationEnabled;
    }

    public void validate() {
        if (this.serverKeyType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property serverKeyType in model ManagedInstanceKeyProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverKeyType", this.serverKeyType == null ? null : this.serverKeyType.toString());
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceKeyProperties deserializedManagedInstanceKeyProperties = new ManagedInstanceKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverKeyType".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.serverKeyType = ServerKeyType.fromString(reader.getString());
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.uri = reader.getString();
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.creationDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("autoRotationEnabled".equals(fieldName)) {
                    deserializedManagedInstanceKeyProperties.autoRotationEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceKeyProperties;
        });
    }
}

