/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SyncAgentState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SyncAgentProperties
implements JsonSerializable<SyncAgentProperties> {
    private String name;
    private String syncDatabaseId;
    private OffsetDateTime lastAliveTime;
    private SyncAgentState state;
    private Boolean isUpToDate;
    private OffsetDateTime expiryTime;
    private String version;

    public String name() {
        return this.name;
    }

    public String syncDatabaseId() {
        return this.syncDatabaseId;
    }

    public SyncAgentProperties withSyncDatabaseId(String syncDatabaseId) {
        this.syncDatabaseId = syncDatabaseId;
        return this;
    }

    public OffsetDateTime lastAliveTime() {
        return this.lastAliveTime;
    }

    public SyncAgentState state() {
        return this.state;
    }

    public Boolean isUpToDate() {
        return this.isUpToDate;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public String version() {
        return this.version;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("syncDatabaseId", this.syncDatabaseId);
        return jsonWriter.writeEndObject();
    }

    public static SyncAgentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SyncAgentProperties deserializedSyncAgentProperties = new SyncAgentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSyncAgentProperties.name = reader.getString();
                    continue;
                }
                if ("syncDatabaseId".equals(fieldName)) {
                    deserializedSyncAgentProperties.syncDatabaseId = reader.getString();
                    continue;
                }
                if ("lastAliveTime".equals(fieldName)) {
                    deserializedSyncAgentProperties.lastAliveTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSyncAgentProperties.state = SyncAgentState.fromString(reader.getString());
                    continue;
                }
                if ("isUpToDate".equals(fieldName)) {
                    deserializedSyncAgentProperties.isUpToDate = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedSyncAgentProperties.expiryTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedSyncAgentProperties.version = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSyncAgentProperties;
        });
    }
}

