/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.ServerAzureADOnlyAuthenticationsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerAzureADOnlyAuthenticationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AuthenticationName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AzureADOnlyAuthListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class ServerAzureADOnlyAuthenticationsClientImpl
implements ServerAzureADOnlyAuthenticationsClient {
    private final ServerAzureADOnlyAuthenticationsService service;
    private final SqlManagementClientImpl client;

    ServerAzureADOnlyAuthenticationsClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(ServerAzureADOnlyAuthenticationsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerAzureADOnlyAuthenticationInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServer(this.client.getEndpoint(), resourceGroupName, serverName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ServerAzureADOnlyAuthenticationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureADOnlyAuthListResult)res.getValue()).value(), ((AzureADOnlyAuthListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerAzureADOnlyAuthenticationInner>> listByServerSinglePageAsync(String resourceGroupName, String serverName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServer(this.client.getEndpoint(), resourceGroupName, serverName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, ServerAzureADOnlyAuthenticationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureADOnlyAuthListResult)res.getValue()).value(), ((AzureADOnlyAuthListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ServerAzureADOnlyAuthenticationInner> listByServerAsync(String resourceGroupName, String serverName) {
        return new PagedFlux<ServerAzureADOnlyAuthenticationInner>(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ServerAzureADOnlyAuthenticationInner> listByServerAsync(String resourceGroupName, String serverName, Context context) {
        return new PagedFlux<ServerAzureADOnlyAuthenticationInner>(() -> this.listByServerSinglePageAsync(resourceGroupName, serverName, context), nextLink -> this.listByServerNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerAzureADOnlyAuthenticationInner> listByServer(String resourceGroupName, String serverName) {
        return new PagedIterable<ServerAzureADOnlyAuthenticationInner>(this.listByServerAsync(resourceGroupName, serverName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ServerAzureADOnlyAuthenticationInner> listByServer(String resourceGroupName, String serverName, Context context) {
        return new PagedIterable<ServerAzureADOnlyAuthenticationInner>(this.listByServerAsync(resourceGroupName, serverName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ServerAzureADOnlyAuthenticationInner>> getWithResponseAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (authenticationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter authenticationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, authenticationName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ServerAzureADOnlyAuthenticationInner>> getWithResponseAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (authenticationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter authenticationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, authenticationName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServerAzureADOnlyAuthenticationInner> getAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName) {
        return this.getWithResponseAsync(resourceGroupName, serverName, authenticationName).flatMap(res -> Mono.justOrEmpty((ServerAzureADOnlyAuthenticationInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ServerAzureADOnlyAuthenticationInner> getWithResponse(String resourceGroupName, String serverName, AuthenticationName authenticationName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serverName, authenticationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerAzureADOnlyAuthenticationInner get(String resourceGroupName, String serverName, AuthenticationName authenticationName) {
        return this.getWithResponse(resourceGroupName, serverName, authenticationName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (authenticationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter authenticationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, authenticationName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (authenticationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter authenticationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, authenticationName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ServerAzureADOnlyAuthenticationInner>, ServerAzureADOnlyAuthenticationInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, authenticationName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ServerAzureADOnlyAuthenticationInner.class), (Type)((Object)ServerAzureADOnlyAuthenticationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ServerAzureADOnlyAuthenticationInner>, ServerAzureADOnlyAuthenticationInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, authenticationName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ServerAzureADOnlyAuthenticationInner.class), (Type)((Object)ServerAzureADOnlyAuthenticationInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ServerAzureADOnlyAuthenticationInner>, ServerAzureADOnlyAuthenticationInner> beginCreateOrUpdate(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, authenticationName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ServerAzureADOnlyAuthenticationInner>, ServerAzureADOnlyAuthenticationInner> beginCreateOrUpdate(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, authenticationName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServerAzureADOnlyAuthenticationInner> createOrUpdateAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, authenticationName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ServerAzureADOnlyAuthenticationInner> createOrUpdateAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, authenticationName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerAzureADOnlyAuthenticationInner createOrUpdate(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters) {
        return this.createOrUpdateAsync(resourceGroupName, serverName, authenticationName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServerAzureADOnlyAuthenticationInner createOrUpdate(String resourceGroupName, String serverName, AuthenticationName authenticationName, ServerAzureADOnlyAuthenticationInner parameters, Context context) {
        return this.createOrUpdateAsync(resourceGroupName, serverName, authenticationName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (authenticationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter authenticationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, authenticationName, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (authenticationName == null) {
            return Mono.error(new IllegalArgumentException("Parameter authenticationName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, serverName, authenticationName, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, authenticationName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serverName, authenticationName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, AuthenticationName authenticationName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, authenticationName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serverName, AuthenticationName authenticationName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serverName, authenticationName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName) {
        return this.beginDeleteAsync(resourceGroupName, serverName, authenticationName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serverName, AuthenticationName authenticationName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serverName, authenticationName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, AuthenticationName authenticationName) {
        this.deleteAsync(resourceGroupName, serverName, authenticationName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serverName, AuthenticationName authenticationName, Context context) {
        this.deleteAsync(resourceGroupName, serverName, authenticationName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerAzureADOnlyAuthenticationInner>> listByServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByServerNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ServerAzureADOnlyAuthenticationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureADOnlyAuthListResult)res.getValue()).value(), ((AzureADOnlyAuthListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ServerAzureADOnlyAuthenticationInner>> listByServerNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByServerNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ServerAzureADOnlyAuthenticationInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AzureADOnlyAuthListResult)res.getValue()).value(), ((AzureADOnlyAuthListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientS")
    public static interface ServerAzureADOnlyAuthenticationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/azureADOnlyAuthentications")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureADOnlyAuthListResult>> listByServer(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/azureADOnlyAuthentications/{authenticationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ServerAzureADOnlyAuthenticationInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="authenticationName") AuthenticationName var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/azureADOnlyAuthentications/{authenticationName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="authenticationName") AuthenticationName var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") ServerAzureADOnlyAuthenticationInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/azureADOnlyAuthentications/{authenticationName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="authenticationName") AuthenticationName var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureADOnlyAuthListResult>> listByServerNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

