/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.FailoverGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.FailoverGroupReadOnlyEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.FailoverGroupReadWriteEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.FailoverGroupReplicationRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.PartnerInfo;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ReadOnlyEndpointFailoverPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ReadWriteEndpointFailoverPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlFailoverGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlFailoverGroupOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServer;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SqlFailoverGroupImpl
extends ExternalChildResourceImpl<SqlFailoverGroup, FailoverGroupInner, SqlServerImpl, SqlServer>
implements SqlFailoverGroup,
SqlFailoverGroup.Update,
SqlFailoverGroupOperations.SqlFailoverGroupOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    protected String sqlServerLocation;

    SqlFailoverGroupImpl(String name, SqlServerImpl parent, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
        this.sqlServerLocation = parent.regionName();
    }

    SqlFailoverGroupImpl(String resourceGroupName, String sqlServerName, String sqlServerLocation, String name, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
    }

    SqlFailoverGroupImpl(String name, FailoverGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString(innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
                this.sqlServerLocation = innerObject.location();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected String sqlServerLocation() {
        return this.sqlServerLocation;
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String id() {
        return ((FailoverGroupInner)this.innerModel()).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId(((FailoverGroupInner)this.innerModel()).id());
    }

    @Override
    public ReadWriteEndpointFailoverPolicy readWriteEndpointPolicy() {
        return ((FailoverGroupInner)this.innerModel()).readWriteEndpoint() != null ? ((FailoverGroupInner)this.innerModel()).readWriteEndpoint().failoverPolicy() : null;
    }

    @Override
    public int readWriteEndpointDataLossGracePeriodMinutes() {
        return ((FailoverGroupInner)this.innerModel()).readWriteEndpoint() != null && ((FailoverGroupInner)this.innerModel()).readWriteEndpoint().failoverWithDataLossGracePeriodMinutes() != null ? ((FailoverGroupInner)this.innerModel()).readWriteEndpoint().failoverWithDataLossGracePeriodMinutes() : 0;
    }

    @Override
    public ReadOnlyEndpointFailoverPolicy readOnlyEndpointPolicy() {
        return ((FailoverGroupInner)this.innerModel()).readOnlyEndpoint() != null ? ((FailoverGroupInner)this.innerModel()).readOnlyEndpoint().failoverPolicy() : null;
    }

    @Override
    public FailoverGroupReplicationRole replicationRole() {
        return ((FailoverGroupInner)this.innerModel()).replicationRole();
    }

    @Override
    public String replicationState() {
        return ((FailoverGroupInner)this.innerModel()).replicationState();
    }

    @Override
    public List<PartnerInfo> partnerServers() {
        return Collections.unmodifiableList(((FailoverGroupInner)this.innerModel()).partnerServers() != null ? ((FailoverGroupInner)this.innerModel()).partnerServers() : new ArrayList());
    }

    @Override
    public List<String> databases() {
        return Collections.unmodifiableList(((FailoverGroupInner)this.innerModel()).databases() != null ? ((FailoverGroupInner)this.innerModel()).databases() : new ArrayList());
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().delete(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public SqlFailoverGroupImpl withExistingSqlServer(String resourceGroupName, String sqlServerName, String sqlServerLocation) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerLocation = sqlServerLocation;
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        this.sqlServerLocation = sqlServer.regionName();
        return this;
    }

    @Override
    public SqlFailoverGroupImpl update() {
        super.prepareUpdate();
        return this;
    }

    @Override
    public Mono<SqlFailoverGroup> createResourceAsync() {
        SqlFailoverGroupImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.name(), (FailoverGroupInner)self.innerModel()).map(failoverGroupInner -> {
            self.setInner(failoverGroupInner);
            return self;
        });
    }

    @Override
    public Mono<SqlFailoverGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    protected Mono<FailoverGroupInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public String type() {
        return ((FailoverGroupInner)this.innerModel()).type();
    }

    @Override
    public String regionName() {
        return ((FailoverGroupInner)this.innerModel()).location();
    }

    @Override
    public Region region() {
        return Region.fromName(((FailoverGroupInner)this.innerModel()).location());
    }

    @Override
    public Map<String, String> tags() {
        return ((FailoverGroupInner)this.innerModel()).tags();
    }

    @Override
    public SqlFailoverGroupImpl withTags(Map<String, String> tags) {
        ((FailoverGroupInner)this.innerModel()).withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withTag(String key, String value) {
        if (((FailoverGroupInner)this.innerModel()).tags() == null) {
            ((FailoverGroupInner)this.innerModel()).withTags(new HashMap<String, String>());
        }
        ((FailoverGroupInner)this.innerModel()).tags().put(key, value);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withoutTag(String key) {
        if (((FailoverGroupInner)this.innerModel()).tags() != null) {
            ((FailoverGroupInner)this.innerModel()).tags().remove(key);
        }
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withAutomaticReadWriteEndpointPolicyAndDataLossGracePeriod(int gracePeriodInMinutes) {
        if (((FailoverGroupInner)this.innerModel()).readWriteEndpoint() == null) {
            ((FailoverGroupInner)this.innerModel()).withReadWriteEndpoint(new FailoverGroupReadWriteEndpoint());
        }
        ((FailoverGroupInner)this.innerModel()).readWriteEndpoint().withFailoverPolicy(ReadWriteEndpointFailoverPolicy.AUTOMATIC);
        ((FailoverGroupInner)this.innerModel()).readWriteEndpoint().withFailoverWithDataLossGracePeriodMinutes(gracePeriodInMinutes);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withManualReadWriteEndpointPolicy() {
        if (((FailoverGroupInner)this.innerModel()).readWriteEndpoint() == null) {
            ((FailoverGroupInner)this.innerModel()).withReadWriteEndpoint(new FailoverGroupReadWriteEndpoint());
        }
        ((FailoverGroupInner)this.innerModel()).readWriteEndpoint().withFailoverPolicy(ReadWriteEndpointFailoverPolicy.MANUAL);
        ((FailoverGroupInner)this.innerModel()).readWriteEndpoint().withFailoverWithDataLossGracePeriodMinutes(null);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withReadOnlyEndpointPolicyEnabled() {
        if (((FailoverGroupInner)this.innerModel()).readOnlyEndpoint() == null) {
            ((FailoverGroupInner)this.innerModel()).withReadOnlyEndpoint(new FailoverGroupReadOnlyEndpoint());
        }
        ((FailoverGroupInner)this.innerModel()).readOnlyEndpoint().withFailoverPolicy(ReadOnlyEndpointFailoverPolicy.ENABLED);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withReadOnlyEndpointPolicyDisabled() {
        if (((FailoverGroupInner)this.innerModel()).readOnlyEndpoint() == null) {
            ((FailoverGroupInner)this.innerModel()).withReadOnlyEndpoint(new FailoverGroupReadOnlyEndpoint());
        }
        ((FailoverGroupInner)this.innerModel()).readOnlyEndpoint().withFailoverPolicy(ReadOnlyEndpointFailoverPolicy.DISABLED);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withPartnerServerId(String id) {
        ((FailoverGroupInner)this.innerModel()).withPartnerServers(new ArrayList<PartnerInfo>());
        ((FailoverGroupInner)this.innerModel()).partnerServers().add(new PartnerInfo().withId(id));
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withDatabaseId(String id) {
        if (((FailoverGroupInner)this.innerModel()).databases() == null) {
            ((FailoverGroupInner)this.innerModel()).withDatabases(new ArrayList<String>());
        }
        ((FailoverGroupInner)this.innerModel()).databases().add(id);
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withNewDatabaseId(String id) {
        return this.withDatabaseId(id);
    }

    @Override
    public SqlFailoverGroupImpl withDatabaseIds(String ... ids) {
        ((FailoverGroupInner)this.innerModel()).withDatabases(new ArrayList<String>());
        for (String id : ids) {
            ((FailoverGroupInner)this.innerModel()).databases().add(id);
        }
        return this;
    }

    @Override
    public SqlFailoverGroupImpl withoutDatabaseId(String id) {
        if (((FailoverGroupInner)this.innerModel()).databases() != null) {
            ((FailoverGroupInner)this.innerModel()).databases().remove(id);
        }
        return this;
    }
}

