/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerSecurityAlertPolicyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerSecurityAlertPolicyImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SecurityAlertPolicyNameAutoGenerated;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicyOperations;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public class SqlServerSecurityAlertPolicyOperationsImpl
implements SqlServerSecurityAlertPolicyOperations,
SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyActionsDefinition {
    protected SqlServerManager sqlServerManager;
    protected SqlServer sqlServer;

    SqlServerSecurityAlertPolicyOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServer = parent;
        this.sqlServerManager = sqlServerManager;
    }

    SqlServerSecurityAlertPolicyOperationsImpl(SqlServerManager sqlServerManager) {
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl define() {
        SqlServerSecurityAlertPolicyImpl result = new SqlServerSecurityAlertPolicyImpl(new ServerSecurityAlertPolicyInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }

    @Override
    public SqlServerSecurityAlertPolicy get() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServer(this.sqlServer);
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> getAsync() {
        if (this.sqlServer == null) {
            return null;
        }
        return this.getBySqlServerAsync(this.sqlServer);
    }

    @Override
    public SqlServerSecurityAlertPolicy getBySqlServer(String resourceGroupName, String sqlServerName) {
        ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerSecurityAlertPolicies().get(resourceGroupName, sqlServerName, SecurityAlertPolicyNameAutoGenerated.DEFAULT);
        return serverSecurityAlertPolicyInner != null ? new SqlServerSecurityAlertPolicyImpl(resourceGroupName, sqlServerName, serverSecurityAlertPolicyInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> getBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        SqlServerSecurityAlertPolicyOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerSecurityAlertPolicies().getAsync(resourceGroupName, sqlServerName, SecurityAlertPolicyNameAutoGenerated.DEFAULT).map(serverSecurityAlertPolicyInner -> new SqlServerSecurityAlertPolicyImpl(resourceGroupName, sqlServerName, (ServerSecurityAlertPolicyInner)serverSecurityAlertPolicyInner, self.sqlServerManager));
    }

    @Override
    public SqlServerSecurityAlertPolicy getBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        ServerSecurityAlertPolicyInner serverSecurityAlertPolicyInner = ((SqlManagementClient)((SqlServerManager)sqlServer.manager()).serviceClient()).getServerSecurityAlertPolicies().get(sqlServer.resourceGroupName(), sqlServer.name(), SecurityAlertPolicyNameAutoGenerated.DEFAULT);
        return serverSecurityAlertPolicyInner != null ? new SqlServerSecurityAlertPolicyImpl((SqlServerImpl)sqlServer, serverSecurityAlertPolicyInner, (SqlServerManager)sqlServer.manager()) : null;
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> getBySqlServerAsync(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)sqlServer.manager()).serviceClient()).getServerSecurityAlertPolicies().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), SecurityAlertPolicyNameAutoGenerated.DEFAULT).map(serverSecurityAlertPolicyInner -> new SqlServerSecurityAlertPolicyImpl((SqlServerImpl)sqlServer, (ServerSecurityAlertPolicyInner)serverSecurityAlertPolicyInner, (SqlServerManager)sqlServer.manager()));
    }

    @Override
    public SqlServerSecurityAlertPolicy getById(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServer(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(ResourceUtils.parentRelativePathFromResourceId(id)));
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        return this.getBySqlServerAsync(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(ResourceUtils.parentRelativePathFromResourceId(id)));
    }
}

