/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobRestoreRange;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class BlobRestoreParameters
implements JsonSerializable<BlobRestoreParameters> {
    private OffsetDateTime timeToRestore;
    private List<BlobRestoreRange> blobRanges;
    private static final ClientLogger LOGGER = new ClientLogger(BlobRestoreParameters.class);

    public OffsetDateTime timeToRestore() {
        return this.timeToRestore;
    }

    public BlobRestoreParameters withTimeToRestore(OffsetDateTime timeToRestore) {
        this.timeToRestore = timeToRestore;
        return this;
    }

    public List<BlobRestoreRange> blobRanges() {
        return this.blobRanges;
    }

    public BlobRestoreParameters withBlobRanges(List<BlobRestoreRange> blobRanges) {
        this.blobRanges = blobRanges;
        return this;
    }

    public void validate() {
        if (this.timeToRestore() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property timeToRestore in model BlobRestoreParameters"));
        }
        if (this.blobRanges() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property blobRanges in model BlobRestoreParameters"));
        }
        this.blobRanges().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeToRestore", this.timeToRestore == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timeToRestore));
        jsonWriter.writeArrayField("blobRanges", this.blobRanges, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static BlobRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobRestoreParameters deserializedBlobRestoreParameters = new BlobRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeToRestore".equals(fieldName)) {
                    deserializedBlobRestoreParameters.timeToRestore = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("blobRanges".equals(fieldName)) {
                    List<BlobRestoreRange> blobRanges = reader.readArray(reader1 -> BlobRestoreRange.fromJson(reader1));
                    deserializedBlobRestoreParameters.blobRanges = blobRanges;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobRestoreParameters;
        });
    }
}

