/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models.StorageAccountPropertiesCreateParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.AccessTier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.AllowedCopyScope;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.CustomDomain;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.DnsEndpointType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Encryption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ExtendedLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Identity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ImmutableStorageAccount;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.KeyPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Kind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.PublicNetworkAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.RoutingPreference;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.SasPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class StorageAccountCreateParameters
implements JsonSerializable<StorageAccountCreateParameters> {
    private Sku sku;
    private Kind kind;
    private String location;
    private ExtendedLocation extendedLocation;
    private Map<String, String> tags;
    private Identity identity;
    private StorageAccountPropertiesCreateParameters innerProperties;
    private static final ClientLogger LOGGER = new ClientLogger(StorageAccountCreateParameters.class);

    public Sku sku() {
        return this.sku;
    }

    public StorageAccountCreateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Kind kind() {
        return this.kind;
    }

    public StorageAccountCreateParameters withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public String location() {
        return this.location;
    }

    public StorageAccountCreateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public StorageAccountCreateParameters withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public StorageAccountCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public StorageAccountCreateParameters withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    private StorageAccountPropertiesCreateParameters innerProperties() {
        return this.innerProperties;
    }

    public AllowedCopyScope allowedCopyScope() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedCopyScope();
    }

    public StorageAccountCreateParameters withAllowedCopyScope(AllowedCopyScope allowedCopyScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withAllowedCopyScope(allowedCopyScope);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public StorageAccountCreateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public SasPolicy sasPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().sasPolicy();
    }

    public StorageAccountCreateParameters withSasPolicy(SasPolicy sasPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withSasPolicy(sasPolicy);
        return this;
    }

    public KeyPolicy keyPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().keyPolicy();
    }

    public StorageAccountCreateParameters withKeyPolicy(KeyPolicy keyPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withKeyPolicy(keyPolicy);
        return this;
    }

    public CustomDomain customDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomain();
    }

    public StorageAccountCreateParameters withCustomDomain(CustomDomain customDomain) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withCustomDomain(customDomain);
        return this;
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public StorageAccountCreateParameters withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public StorageAccountCreateParameters withNetworkRuleSet(NetworkRuleSet networkRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withNetworkRuleSet(networkRuleSet);
        return this;
    }

    public AccessTier accessTier() {
        return this.innerProperties() == null ? null : this.innerProperties().accessTier();
    }

    public StorageAccountCreateParameters withAccessTier(AccessTier accessTier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withAccessTier(accessTier);
        return this;
    }

    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().azureFilesIdentityBasedAuthentication();
    }

    public StorageAccountCreateParameters withAzureFilesIdentityBasedAuthentication(AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withAzureFilesIdentityBasedAuthentication(azureFilesIdentityBasedAuthentication);
        return this;
    }

    public Boolean enableHttpsTrafficOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().enableHttpsTrafficOnly();
    }

    public StorageAccountCreateParameters withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withEnableHttpsTrafficOnly(enableHttpsTrafficOnly);
        return this;
    }

    public Boolean isSftpEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isSftpEnabled();
    }

    public StorageAccountCreateParameters withIsSftpEnabled(Boolean isSftpEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withIsSftpEnabled(isSftpEnabled);
        return this;
    }

    public Boolean isLocalUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isLocalUserEnabled();
    }

    public StorageAccountCreateParameters withIsLocalUserEnabled(Boolean isLocalUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withIsLocalUserEnabled(isLocalUserEnabled);
        return this;
    }

    public Boolean enableExtendedGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().enableExtendedGroups();
    }

    public StorageAccountCreateParameters withEnableExtendedGroups(Boolean enableExtendedGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withEnableExtendedGroups(enableExtendedGroups);
        return this;
    }

    public Boolean isHnsEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isHnsEnabled();
    }

    public StorageAccountCreateParameters withIsHnsEnabled(Boolean isHnsEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withIsHnsEnabled(isHnsEnabled);
        return this;
    }

    public LargeFileSharesState largeFileSharesState() {
        return this.innerProperties() == null ? null : this.innerProperties().largeFileSharesState();
    }

    public StorageAccountCreateParameters withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withLargeFileSharesState(largeFileSharesState);
        return this;
    }

    public RoutingPreference routingPreference() {
        return this.innerProperties() == null ? null : this.innerProperties().routingPreference();
    }

    public StorageAccountCreateParameters withRoutingPreference(RoutingPreference routingPreference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withRoutingPreference(routingPreference);
        return this;
    }

    public Boolean allowBlobPublicAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().allowBlobPublicAccess();
    }

    public StorageAccountCreateParameters withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withAllowBlobPublicAccess(allowBlobPublicAccess);
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public StorageAccountCreateParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public Boolean allowSharedKeyAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().allowSharedKeyAccess();
    }

    public StorageAccountCreateParameters withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withAllowSharedKeyAccess(allowSharedKeyAccess);
        return this;
    }

    public Boolean enableNfsV3() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNfsV3();
    }

    public StorageAccountCreateParameters withEnableNfsV3(Boolean enableNfsV3) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withEnableNfsV3(enableNfsV3);
        return this;
    }

    public Boolean allowCrossTenantReplication() {
        return this.innerProperties() == null ? null : this.innerProperties().allowCrossTenantReplication();
    }

    public StorageAccountCreateParameters withAllowCrossTenantReplication(Boolean allowCrossTenantReplication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withAllowCrossTenantReplication(allowCrossTenantReplication);
        return this;
    }

    public Boolean defaultToOAuthAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultToOAuthAuthentication();
    }

    public StorageAccountCreateParameters withDefaultToOAuthAuthentication(Boolean defaultToOAuthAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withDefaultToOAuthAuthentication(defaultToOAuthAuthentication);
        return this;
    }

    public ImmutableStorageAccount immutableStorageWithVersioning() {
        return this.innerProperties() == null ? null : this.innerProperties().immutableStorageWithVersioning();
    }

    public StorageAccountCreateParameters withImmutableStorageWithVersioning(ImmutableStorageAccount immutableStorageWithVersioning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withImmutableStorageWithVersioning(immutableStorageWithVersioning);
        return this;
    }

    public DnsEndpointType dnsEndpointType() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsEndpointType();
    }

    public StorageAccountCreateParameters withDnsEndpointType(DnsEndpointType dnsEndpointType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesCreateParameters();
        }
        this.innerProperties().withDnsEndpointType(dnsEndpointType);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sku in model StorageAccountCreateParameters"));
        }
        this.sku().validate();
        if (this.kind() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property kind in model StorageAccountCreateParameters"));
        }
        if (this.location() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property location in model StorageAccountCreateParameters"));
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("extendedLocation", this.extendedLocation);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static StorageAccountCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageAccountCreateParameters deserializedStorageAccountCreateParameters = new StorageAccountCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedStorageAccountCreateParameters.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedStorageAccountCreateParameters.kind = Kind.fromString(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedStorageAccountCreateParameters.location = reader.getString();
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedStorageAccountCreateParameters.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedStorageAccountCreateParameters.tags = tags;
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedStorageAccountCreateParameters.identity = Identity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageAccountCreateParameters.innerProperties = StorageAccountPropertiesCreateParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageAccountCreateParameters;
        });
    }
}

