/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.AlwaysServe;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointMonitorStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointPropertiesCustomHeadersItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointPropertiesSubnetsItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointStatus;
import java.io.IOException;
import java.util.List;

public final class EndpointProperties
implements JsonSerializable<EndpointProperties> {
    private String targetResourceId;
    private String target;
    private EndpointStatus endpointStatus;
    private Long weight;
    private Long priority;
    private String endpointLocation;
    private EndpointMonitorStatus endpointMonitorStatus;
    private Long minChildEndpoints;
    private Long minChildEndpointsIPv4;
    private Long minChildEndpointsIPv6;
    private List<String> geoMapping;
    private List<EndpointPropertiesSubnetsItem> subnets;
    private List<EndpointPropertiesCustomHeadersItem> customHeaders;
    private AlwaysServe alwaysServe;

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public EndpointProperties withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public String target() {
        return this.target;
    }

    public EndpointProperties withTarget(String target) {
        this.target = target;
        return this;
    }

    public EndpointStatus endpointStatus() {
        return this.endpointStatus;
    }

    public EndpointProperties withEndpointStatus(EndpointStatus endpointStatus) {
        this.endpointStatus = endpointStatus;
        return this;
    }

    public Long weight() {
        return this.weight;
    }

    public EndpointProperties withWeight(Long weight) {
        this.weight = weight;
        return this;
    }

    public Long priority() {
        return this.priority;
    }

    public EndpointProperties withPriority(Long priority) {
        this.priority = priority;
        return this;
    }

    public String endpointLocation() {
        return this.endpointLocation;
    }

    public EndpointProperties withEndpointLocation(String endpointLocation) {
        this.endpointLocation = endpointLocation;
        return this;
    }

    public EndpointMonitorStatus endpointMonitorStatus() {
        return this.endpointMonitorStatus;
    }

    public EndpointProperties withEndpointMonitorStatus(EndpointMonitorStatus endpointMonitorStatus) {
        this.endpointMonitorStatus = endpointMonitorStatus;
        return this;
    }

    public Long minChildEndpoints() {
        return this.minChildEndpoints;
    }

    public EndpointProperties withMinChildEndpoints(Long minChildEndpoints) {
        this.minChildEndpoints = minChildEndpoints;
        return this;
    }

    public Long minChildEndpointsIPv4() {
        return this.minChildEndpointsIPv4;
    }

    public EndpointProperties withMinChildEndpointsIPv4(Long minChildEndpointsIPv4) {
        this.minChildEndpointsIPv4 = minChildEndpointsIPv4;
        return this;
    }

    public Long minChildEndpointsIPv6() {
        return this.minChildEndpointsIPv6;
    }

    public EndpointProperties withMinChildEndpointsIPv6(Long minChildEndpointsIPv6) {
        this.minChildEndpointsIPv6 = minChildEndpointsIPv6;
        return this;
    }

    public List<String> geoMapping() {
        return this.geoMapping;
    }

    public EndpointProperties withGeoMapping(List<String> geoMapping) {
        this.geoMapping = geoMapping;
        return this;
    }

    public List<EndpointPropertiesSubnetsItem> subnets() {
        return this.subnets;
    }

    public EndpointProperties withSubnets(List<EndpointPropertiesSubnetsItem> subnets) {
        this.subnets = subnets;
        return this;
    }

    public List<EndpointPropertiesCustomHeadersItem> customHeaders() {
        return this.customHeaders;
    }

    public EndpointProperties withCustomHeaders(List<EndpointPropertiesCustomHeadersItem> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public AlwaysServe alwaysServe() {
        return this.alwaysServe;
    }

    public EndpointProperties withAlwaysServe(AlwaysServe alwaysServe) {
        this.alwaysServe = alwaysServe;
        return this;
    }

    public void validate() {
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
        if (this.customHeaders() != null) {
            this.customHeaders().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeStringField("endpointStatus", this.endpointStatus == null ? null : this.endpointStatus.toString());
        jsonWriter.writeNumberField("weight", this.weight);
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeStringField("endpointLocation", this.endpointLocation);
        jsonWriter.writeStringField("endpointMonitorStatus", this.endpointMonitorStatus == null ? null : this.endpointMonitorStatus.toString());
        jsonWriter.writeNumberField("minChildEndpoints", this.minChildEndpoints);
        jsonWriter.writeNumberField("minChildEndpointsIPv4", this.minChildEndpointsIPv4);
        jsonWriter.writeNumberField("minChildEndpointsIPv6", this.minChildEndpointsIPv6);
        jsonWriter.writeArrayField("geoMapping", this.geoMapping, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("subnets", this.subnets, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("customHeaders", this.customHeaders, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("alwaysServe", this.alwaysServe == null ? null : this.alwaysServe.toString());
        return jsonWriter.writeEndObject();
    }

    public static EndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EndpointProperties deserializedEndpointProperties = new EndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    deserializedEndpointProperties.targetResourceId = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedEndpointProperties.target = reader.getString();
                    continue;
                }
                if ("endpointStatus".equals(fieldName)) {
                    deserializedEndpointProperties.endpointStatus = EndpointStatus.fromString(reader.getString());
                    continue;
                }
                if ("weight".equals(fieldName)) {
                    deserializedEndpointProperties.weight = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedEndpointProperties.priority = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("endpointLocation".equals(fieldName)) {
                    deserializedEndpointProperties.endpointLocation = reader.getString();
                    continue;
                }
                if ("endpointMonitorStatus".equals(fieldName)) {
                    deserializedEndpointProperties.endpointMonitorStatus = EndpointMonitorStatus.fromString(reader.getString());
                    continue;
                }
                if ("minChildEndpoints".equals(fieldName)) {
                    deserializedEndpointProperties.minChildEndpoints = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("minChildEndpointsIPv4".equals(fieldName)) {
                    deserializedEndpointProperties.minChildEndpointsIPv4 = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("minChildEndpointsIPv6".equals(fieldName)) {
                    deserializedEndpointProperties.minChildEndpointsIPv6 = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("geoMapping".equals(fieldName)) {
                    List<String> geoMapping = reader.readArray(reader1 -> reader1.getString());
                    deserializedEndpointProperties.geoMapping = geoMapping;
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List<EndpointPropertiesSubnetsItem> subnets = reader.readArray(reader1 -> EndpointPropertiesSubnetsItem.fromJson(reader1));
                    deserializedEndpointProperties.subnets = subnets;
                    continue;
                }
                if ("customHeaders".equals(fieldName)) {
                    List<EndpointPropertiesCustomHeadersItem> customHeaders = reader.readArray(reader1 -> EndpointPropertiesCustomHeadersItem.fromJson(reader1));
                    deserializedEndpointProperties.customHeaders = customHeaders;
                    continue;
                }
                if ("alwaysServe".equals(fieldName)) {
                    deserializedEndpointProperties.alwaysServe = AlwaysServe.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointProperties;
        });
    }
}

