/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.HeatMapEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficFlow;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class HeatMapProperties
implements JsonSerializable<HeatMapProperties> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private List<HeatMapEndpoint> endpoints;
    private List<TrafficFlow> trafficFlows;

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public HeatMapProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public HeatMapProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<HeatMapEndpoint> endpoints() {
        return this.endpoints;
    }

    public HeatMapProperties withEndpoints(List<HeatMapEndpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public List<TrafficFlow> trafficFlows() {
        return this.trafficFlows;
    }

    public HeatMapProperties withTrafficFlows(List<TrafficFlow> trafficFlows) {
        this.trafficFlows = trafficFlows;
        return this;
    }

    public void validate() {
        if (this.endpoints() != null) {
            this.endpoints().forEach(e -> e.validate());
        }
        if (this.trafficFlows() != null) {
            this.trafficFlows().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeArrayField("endpoints", this.endpoints, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("trafficFlows", this.trafficFlows, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static HeatMapProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HeatMapProperties deserializedHeatMapProperties = new HeatMapProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedHeatMapProperties.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedHeatMapProperties.endTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endpoints".equals(fieldName)) {
                    List<HeatMapEndpoint> endpoints = reader.readArray(reader1 -> HeatMapEndpoint.fromJson(reader1));
                    deserializedHeatMapProperties.endpoints = endpoints;
                    continue;
                }
                if ("trafficFlows".equals(fieldName)) {
                    List<TrafficFlow> trafficFlows = reader.readArray(reader1 -> TrafficFlow.fromJson(reader1));
                    deserializedHeatMapProperties.trafficFlows = trafficFlows;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHeatMapProperties;
        });
    }
}

