/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.ConfigurationTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.HttpTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.TokenCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.AddHeadersPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLoggingPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPolicyProviders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.UserAgentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.TracingOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.builder.ClientBuilderUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.Tracer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.TracerProvider;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.KeyServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyVaultCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={KeyClient.class})
public final class KeyClientBuilder
implements TokenCredentialTrait<KeyClientBuilder>,
HttpTrait<KeyClientBuilder>,
ConfigurationTrait<KeyClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(KeyClientBuilder.class);
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS;
    private final List<HttpPipelinePolicy> perCallPolicies;
    private final List<HttpPipelinePolicy> perRetryPolicies;
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private String vaultUrl;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private KeyServiceVersion version;
    private ClientOptions clientOptions;
    private boolean disableChallengeResourceVerification = false;

    public KeyClientBuilder() {
        this.perCallPolicies = new ArrayList<HttpPipelinePolicy>();
        this.perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    }

    public KeyClient buildClient() {
        return new KeyClient(this.buildInnerClient(), this.vaultUrl, this.version != null ? this.version : KeyServiceVersion.getLatest());
    }

    public KeyAsyncClient buildAsyncClient() {
        return new KeyAsyncClient(this.buildInnerClient(), this.vaultUrl, this.version != null ? this.version : KeyServiceVersion.getLatest());
    }

    private KeyClientImpl buildInnerClient() {
        KeyServiceVersion serviceVersion;
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        String buildEndpoint = this.getBuildEndpoint(buildConfiguration);
        if (buildEndpoint == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Azure Key Vault endpoint url is required."));
        }
        KeyServiceVersion keyServiceVersion = serviceVersion = this.version != null ? this.version : KeyServiceVersion.getLatest();
        if (this.pipeline != null) {
            return new KeyClientImpl(this.pipeline, serviceVersion.getVersion());
        }
        if (this.credential == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Azure Key Vault credentials are required."));
        }
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        this.httpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions != null ? this.clientOptions : DEFAULT_CLIENT_OPTIONS;
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId(localClientOptions, this.httpLogOptions), CLIENT_NAME, CLIENT_VERSION, buildConfiguration));
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions(localClientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(new HttpHeaders((Iterable<HttpHeader>)headers)));
        }
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy(this.retryPolicy, this.retryOptions));
        policies.add(new KeyVaultCredentialPolicy(this.credential, this.disableChallengeResourceVerification));
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        TracingOptions tracingOptions = localClientOptions.getTracingOptions();
        Tracer tracer = TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, KEYVAULT_TRACING_NAMESPACE_VALUE, tracingOptions);
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).tracer(tracer).clientOptions(localClientOptions).build();
        return new KeyClientImpl(pipeline, serviceVersion.getVersion());
    }

    public KeyClientBuilder vaultUrl(String vaultUrl) {
        if (vaultUrl == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'vaultUrl' cannot be null."));
        }
        try {
            URL url = new URL(vaultUrl);
            this.vaultUrl = url.toString();
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Azure Key Vault url is malformed.", ex));
        }
        return this;
    }

    @Override
    public KeyClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    @Override
    public KeyClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    @Override
    public KeyClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'policy' cannot be null."));
        }
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    @Override
    public KeyClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    @Override
    public KeyClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public KeyClientBuilder serviceVersion(KeyServiceVersion version) {
        this.version = version;
        return this;
    }

    @Override
    public KeyClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public KeyClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public KeyClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    @Override
    public KeyClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public KeyClientBuilder disableChallengeResourceVerification() {
        this.disableChallengeResourceVerification = true;
        return this;
    }

    private String getBuildEndpoint(Configuration configuration) {
        if (this.vaultUrl != null) {
            return this.vaultUrl;
        }
        String configEndpoint = configuration.get("AZURE_KEYVAULT_ENDPOINT");
        if (CoreUtils.isNullOrEmpty(configEndpoint)) {
            return null;
        }
        try {
            URL url = new URL(configEndpoint);
            return url.toString();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    static {
        Map<String, String> properties = CoreUtils.getProperties("azure-key-vault-keys.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
        DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    }
}

