/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation;

import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.Ecdsa;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Arrays;

final class Asn1DerSignatureEncoding {
    private Asn1DerSignatureEncoding() {
    }

    static byte[] encode(byte[] signature, Ecdsa algorithm) {
        int coordLength = algorithm.getCoordLength();
        if (signature.length != coordLength * 2) {
            throw new IllegalArgumentException("Invalid signature.");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(signature, 0, signature.length / 2));
        BigInteger s2 = new BigInteger(1, Arrays.copyOfRange(signature, signature.length / 2, signature.length));
        byte[] rfield = Asn1DerSignatureEncoding.encodeIntField(r);
        byte[] sfield = Asn1DerSignatureEncoding.encodeIntField(s2);
        ByteArrayOutputStream asn1DerSignature = new ByteArrayOutputStream();
        asn1DerSignature.write(48);
        Asn1DerSignatureEncoding.writeFieldLength(asn1DerSignature, rfield.length + sfield.length);
        asn1DerSignature.write(rfield, 0, rfield.length);
        asn1DerSignature.write(sfield, 0, sfield.length);
        return asn1DerSignature.toByteArray();
    }

    static byte[] decode(byte[] bytes, Ecdsa algorithm) {
        int coordLength = algorithm.getCoordLength();
        ByteArrayInputStream asn1DerSignature = new ByteArrayInputStream(bytes);
        if (asn1DerSignature.read() != 48) {
            throw new IllegalArgumentException("Invalid signature.");
        }
        int objLen = Asn1DerSignatureEncoding.readFieldLength(asn1DerSignature);
        if (objLen != asn1DerSignature.available()) {
            throw new IllegalArgumentException(String.format("Invalid signature; invalid field len %d", objLen));
        }
        byte[] rawSignature = new byte[coordLength * 2];
        Asn1DerSignatureEncoding.decodeIntField(asn1DerSignature, rawSignature, 0, coordLength);
        Asn1DerSignatureEncoding.decodeIntField(asn1DerSignature, rawSignature, rawSignature.length / 2, coordLength);
        return rawSignature;
    }

    static byte[] encodeIntField(BigInteger i) {
        ByteArrayOutputStream field = new ByteArrayOutputStream();
        field.write(2);
        byte[] vi = i.toByteArray();
        Asn1DerSignatureEncoding.writeFieldLength(field, vi.length);
        field.write(vi, 0, vi.length);
        return field.toByteArray();
    }

    static void writeFieldLength(ByteArrayOutputStream field, int len) {
        if (len < 128) {
            field.write(len);
        } else {
            byte[] blen = BigInteger.valueOf(len).toByteArray();
            int lenlen = blen.length;
            if (blen[0] == 0) {
                --lenlen;
            }
            field.write(0x80 | lenlen);
            field.write(blen, blen.length - lenlen, lenlen);
        }
    }

    static void decodeIntField(ByteArrayInputStream bytes, byte[] dest, int index, int intlen) {
        if (bytes.read() != 2) {
            throw new IllegalArgumentException("Invalid signature.");
        }
        int len = Asn1DerSignatureEncoding.readFieldLength(bytes);
        if (len > intlen + 1 || len > bytes.available()) {
            throw new IllegalArgumentException("Invalid signature.");
        }
        if (len > intlen) {
            bytes.skip(1L);
            --len;
        }
        bytes.read(dest, index + (intlen - len), len);
    }

    static int readFieldLength(ByteArrayInputStream bytes) {
        int firstLenByte = bytes.read();
        if ((firstLenByte & 0x80) == 0) {
            return firstLenByte;
        }
        int numLenBytes = firstLenByte ^ 0x80;
        if (numLenBytes > bytes.available()) {
            throw new IllegalArgumentException("Invalid signature.");
        }
        byte[] lenBytes = new byte[numLenBytes];
        bytes.read(lenBytes, 0, numLenBytes);
        BigInteger bigLen = new BigInteger(1, lenBytes);
        if (bigLen.bitLength() >= 31) {
            throw new IllegalArgumentException("Invalid signature.");
        }
        return bigLen.intValue();
    }
}

