/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.DeletedKeyHelper;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyVaultKeysUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.JsonWebKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyProperties;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyReleasePolicy;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyVaultKey;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DeletedKey
extends KeyVaultKey {
    private String recoveryId;
    private OffsetDateTime scheduledPurgeDate;
    private OffsetDateTime deletedOn;

    public DeletedKey() {
    }

    private DeletedKey(JsonWebKey jsonWebKey) {
        super(jsonWebKey);
    }

    private DeletedKey(JsonWebKey jsonWebKey, KeyProperties properties, String recoveryId, OffsetDateTime scheduledPurgeDate, OffsetDateTime deletedOn) {
        super(jsonWebKey, properties);
        this.recoveryId = recoveryId;
        this.scheduledPurgeDate = scheduledPurgeDate;
        this.deletedOn = deletedOn;
    }

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        return this.scheduledPurgeDate;
    }

    public OffsetDateTime getDeletedOn() {
        return this.deletedOn;
    }

    @Override
    public JsonWebKey getKey() {
        return super.getKey();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeJsonField("key", this.getKey()).writeStringField("recoveryId", this.recoveryId).writeEndObject();
    }

    public static DeletedKey fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            JsonWebKey webKey = null;
            KeyProperties properties = new KeyProperties();
            String recoveryId = null;
            OffsetDateTime scheduledPurgeDate = null;
            OffsetDateTime deletedOn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    webKey = JsonWebKey.fromJson(reader);
                    KeyVaultKeysUtils.unpackId(webKey.getId(), name -> {
                        properties.name = name;
                    }, version -> {
                        properties.version = version;
                    });
                    continue;
                }
                if ("attributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("enabled".equals(fieldName)) {
                            properties.enabled = reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("exportable".equals(fieldName)) {
                            properties.exportable = reader.getNullable(JsonReader::getBoolean);
                            continue;
                        }
                        if ("nbf".equals(fieldName)) {
                            properties.notBefore = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("exp".equals(fieldName)) {
                            properties.expiresOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("created".equals(fieldName)) {
                            properties.createdOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("updated".equals(fieldName)) {
                            properties.updatedOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                            continue;
                        }
                        if ("recoveryLevel".equals(fieldName)) {
                            properties.recoveryLevel = reader.getString();
                            continue;
                        }
                        if ("recoverableDays".equals(fieldName)) {
                            properties.recoverableDays = reader.getNullable(JsonReader::getInt);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    properties.setTags(reader.readMap(JsonReader::getString));
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    properties.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("release_policy".equals(fieldName)) {
                    properties.setReleasePolicy(KeyReleasePolicy.fromJson(reader));
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    scheduledPurgeDate = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deletedOn = reader.getNullable(KeyVaultKeysUtils::epochToOffsetDateTime);
                    continue;
                }
                reader.skipChildren();
            }
            return new DeletedKey(webKey, properties, recoveryId, scheduledPurgeDate, deletedOn);
        });
    }

    static {
        DeletedKeyHelper.setAccessor(new DeletedKeyHelper.DeletedKeyAccessor(){

            @Override
            public DeletedKey createDeletedKey(JsonWebKey jsonWebKey) {
                return new DeletedKey(jsonWebKey);
            }

            @Override
            public void setRecoveryId(DeletedKey deletedKey, String recoveryId) {
                deletedKey.recoveryId = recoveryId;
            }

            @Override
            public void setScheduledPurgeDate(DeletedKey deletedKey, OffsetDateTime scheduledPurgeDate) {
                deletedKey.scheduledPurgeDate = scheduledPurgeDate;
            }

            @Override
            public void setDeletedOn(DeletedKey deletedKey, OffsetDateTime deletedOn) {
                deletedKey.deletedOn = deletedOn;
            }
        });
    }
}

