/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyRotationLifetimeActionHelper;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.LifetimeActionsTrigger;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.LifetimeActionsType;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyRotationPolicyAction;
import java.io.IOException;

public final class KeyRotationLifetimeAction
implements JsonSerializable<KeyRotationLifetimeAction> {
    private final LifetimeActionsTrigger trigger;
    private final LifetimeActionsType actionType;

    public KeyRotationLifetimeAction(KeyRotationPolicyAction action) {
        this.actionType = new LifetimeActionsType().setType(action);
        this.trigger = new LifetimeActionsTrigger();
    }

    private KeyRotationLifetimeAction(LifetimeActionsTrigger trigger, LifetimeActionsType actionsType) {
        this.trigger = trigger;
        this.actionType = actionsType;
    }

    public KeyRotationPolicyAction getAction() {
        return this.actionType.getType();
    }

    public String getTimeAfterCreate() {
        return this.trigger.getTimeAfterCreate();
    }

    public KeyRotationLifetimeAction setTimeAfterCreate(String timeAfterCreate) {
        this.trigger.setTimeAfterCreate(timeAfterCreate);
        return this;
    }

    public String getTimeBeforeExpiry() {
        return this.trigger.getTimeBeforeExpiry();
    }

    public KeyRotationLifetimeAction setTimeBeforeExpiry(String timeBeforeExpiry) {
        this.trigger.setTimeBeforeExpiry(timeBeforeExpiry);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeJsonField("trigger", this.trigger).writeJsonField("action", this.actionType).writeEndObject();
    }

    public static KeyRotationLifetimeAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LifetimeActionsTrigger trigger = null;
            LifetimeActionsType actionType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trigger".equals(fieldName)) {
                    trigger = LifetimeActionsTrigger.fromJson(reader);
                    continue;
                }
                if ("action".equals(fieldName)) {
                    actionType = LifetimeActionsType.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new KeyRotationLifetimeAction(trigger, actionType);
        });
    }

    static {
        KeyRotationLifetimeActionHelper.setAccessor(new KeyRotationLifetimeActionHelper.KeyRotationLifetimeActionAccessor(){

            @Override
            public KeyRotationLifetimeAction createLifetimeAction(LifetimeActionsTrigger trigger, LifetimeActionsType actionsType) {
                return new KeyRotationLifetimeAction(trigger, actionsType);
            }

            @Override
            public LifetimeActionsTrigger getTrigger(KeyRotationLifetimeAction lifetimeAction) {
                return lifetimeAction.trigger;
            }

            @Override
            public LifetimeActionsType getActionType(KeyRotationLifetimeAction lifetimeAction) {
                return lifetimeAction.actionType;
            }
        });
    }
}

