/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.SecretsModelsUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.models.SecretProperties;
import java.io.IOException;
import java.util.Objects;

public class KeyVaultSecret
implements JsonSerializable<KeyVaultSecret> {
    String value;
    SecretProperties properties;

    KeyVaultSecret() {
        this.properties = new SecretProperties();
    }

    public KeyVaultSecret(String name, String value) {
        this.properties = new SecretProperties(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getId() {
        return this.properties.getId();
    }

    public String getName() {
        return this.properties.getName();
    }

    public SecretProperties getProperties() {
        return this.properties;
    }

    public KeyVaultSecret setProperties(SecretProperties properties) {
        Objects.requireNonNull(properties);
        properties.name = this.properties.name;
        this.properties = properties;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("value", this.value).writeEndObject();
    }

    public static KeyVaultSecret fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultSecret keyVaultSecret = new KeyVaultSecret();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    keyVaultSecret.value = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    keyVaultSecret.properties.id = reader.getString();
                    SecretsModelsUtils.unpackId(keyVaultSecret.properties.id, name -> {
                        keyVaultSecret.properties.name = name;
                    }, version -> {
                        keyVaultSecret.properties.version = version;
                    });
                    continue;
                }
                if ("attributes".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    SecretProperties.deserializeAttributes(reader, keyVaultSecret.properties);
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    keyVaultSecret.properties.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    keyVaultSecret.properties.keyId = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    keyVaultSecret.properties.contentType = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    keyVaultSecret.properties.tags = reader.readMap(JsonReader::getString);
                    continue;
                }
                reader.skipChildren();
            }
            return keyVaultSecret;
        });
    }
}

