/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.EncryptionScope;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.FilterBlobSegment;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ServicesFilterBlobsHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.ServicesGetAccountInfoHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util.ModelHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobCorsRule;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobServiceStatistics;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CpkInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.KeyInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ListBlobContainersOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.PublicAccessType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.StorageAccountInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.TaggedBlobItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.UserDelegationKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.FindBlobsOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.UndeleteBlobContainerOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.AccountSasImplUtil;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.Constants;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.SasImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.sas.AccountSasSignatureValues;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.net.URI;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@ServiceClient(builder=BlobServiceClientBuilder.class, isAsync=true)
public final class BlobServiceAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(BlobServiceAsyncClient.class);
    private final AzureBlobStorageImpl azureBlobStorage;
    private final String accountName;
    private final BlobServiceVersion serviceVersion;
    private final CpkInfo customerProvidedKey;
    private final EncryptionScope encryptionScope;
    private final BlobContainerEncryptionScope blobContainerEncryptionScope;
    private final boolean anonymousAccess;

    BlobServiceAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, BlobContainerEncryptionScope blobContainerEncryptionScope, boolean anonymousAccess) {
        try {
            URI.create(url);
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
        this.azureBlobStorage = new AzureBlobStorageImplBuilder().pipeline(pipeline).url(url).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.customerProvidedKey = customerProvidedKey;
        this.encryptionScope = encryptionScope;
        this.blobContainerEncryptionScope = blobContainerEncryptionScope;
        this.anonymousAccess = anonymousAccess;
    }

    public BlobContainerAsyncClient getBlobContainerAsyncClient(String containerName) {
        if (CoreUtils.isNullOrEmpty(containerName)) {
            containerName = "$root";
        }
        return new BlobContainerAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), containerName, this.customerProvidedKey, this.encryptionScope, this.blobContainerEncryptionScope);
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureBlobStorage.getHttpPipeline();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    CpkInfo getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    EncryptionScope getEncryptionScope() {
        return this.encryptionScope;
    }

    BlobContainerEncryptionScope getBlobContainerEncryptionScope() {
        return this.blobContainerEncryptionScope;
    }

    boolean isAnonymousAccess() {
        return this.anonymousAccess;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobContainerAsyncClient> createBlobContainer(String containerName) {
        return this.createBlobContainerWithResponse(containerName, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobContainerAsyncClient>> createBlobContainerWithResponse(String containerName, Map<String, String> metadata, PublicAccessType accessType) {
        try {
            return FluxUtil.withContext(context -> this.createBlobContainerWithResponse(containerName, metadata, accessType, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<BlobContainerAsyncClient>> createBlobContainerWithResponse(String containerName, Map<String, String> metadata, PublicAccessType accessType, Context context) {
        this.throwOnAnonymousAccess();
        BlobContainerAsyncClient blobContainerAsyncClient = this.getBlobContainerAsyncClient(containerName);
        return blobContainerAsyncClient.createWithResponse(metadata, accessType, context).map(response -> new SimpleResponse<BlobContainerAsyncClient>((Response<?>)response, blobContainerAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobContainerAsyncClient> createBlobContainerIfNotExists(String containerName) {
        return this.createBlobContainerIfNotExistsWithResponse(containerName, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobContainerAsyncClient>> createBlobContainerIfNotExistsWithResponse(String containerName, BlobContainerCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createBlobContainerIfNotExistsWithResponse(containerName, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<BlobContainerAsyncClient>> createBlobContainerIfNotExistsWithResponse(String containerName, BlobContainerCreateOptions options, Context context) {
        try {
            options = options == null ? new BlobContainerCreateOptions() : options;
            return this.createBlobContainerWithResponse(containerName, options.getMetadata(), options.getPublicAccessType(), context).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)t).getStatusCode() == 409, t -> {
                HttpResponse response = ((BlobStorageException)t).getResponse();
                return Mono.just(new SimpleResponse<BlobContainerAsyncClient>(response.getRequest(), response.getStatusCode(), response.getHeaders(), this.getBlobContainerAsyncClient(containerName)));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBlobContainer(String containerName) {
        return this.deleteBlobContainerWithResponse(containerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBlobContainerWithResponse(String containerName) {
        try {
            return FluxUtil.withContext(context -> this.deleteBlobContainerWithResponse(containerName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Void>> deleteBlobContainerWithResponse(String containerName, Context context) {
        this.throwOnAnonymousAccess();
        return this.getBlobContainerAsyncClient(containerName).deleteWithResponse(null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteBlobContainerIfExists(String containerName) {
        return this.deleteBlobContainerIfExistsWithResponse(containerName).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteBlobContainerIfExistsWithResponse(String containerName) {
        try {
            return FluxUtil.withContext(context -> this.deleteBlobContainerIfExistsWithResponse(containerName, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Boolean>> deleteBlobContainerIfExistsWithResponse(String containerName, Context context) {
        try {
            return this.deleteBlobContainerWithResponse(containerName, context).map(response -> new SimpleResponse<Boolean>((Response<?>)response, true)).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)t).getStatusCode() == 404, t -> {
                HttpResponse response = ((BlobStorageException)t).getResponse();
                return Mono.just(new SimpleResponse<Boolean>(response.getRequest(), response.getStatusCode(), response.getHeaders(), false));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    public String getAccountUrl() {
        return this.azureBlobStorage.getUrl();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainers() {
        return this.listBlobContainers(new ListBlobContainersOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BlobContainerItem> listBlobContainers(ListBlobContainersOptions options) {
        try {
            return this.listBlobContainersWithOptionalTimeout(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    PagedFlux<BlobContainerItem> listBlobContainersWithOptionalTimeout(ListBlobContainersOptions options, Duration timeout2) {
        this.throwOnAnonymousAccess();
        BiFunction func = (marker, pageSize) -> {
            ListBlobContainersOptions finalOptions = pageSize != null ? (options == null ? new ListBlobContainersOptions().setMaxResultsPerPage((Integer)pageSize) : new ListBlobContainersOptions().setMaxResultsPerPage((Integer)pageSize).setDetails(options.getDetails()).setPrefix(options.getPrefix())) : options;
            return this.listBlobContainersSegment((String)marker, finalOptions, timeout2);
        };
        return new PagedFlux<BlobContainerItem>(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<PagedResponse<BlobContainerItem>> listBlobContainersSegment(String marker, ListBlobContainersOptions options, Duration timeout2) {
        options = options == null ? new ListBlobContainersOptions() : options;
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getServices().listBlobContainersSegmentSinglePageAsync(options.getPrefix(), marker, options.getMaxResultsPerPage(), ModelHelper.toIncludeTypes(options.getDetails()), null, null, Context.NONE), timeout2);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TaggedBlobItem> findBlobsByTags(String query) {
        return this.findBlobsByTags(new FindBlobsOptions(query));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options) {
        try {
            return this.findBlobsByTags(options, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    PagedFlux<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options, Duration timeout2, Context context) {
        this.throwOnAnonymousAccess();
        StorageImplUtils.assertNotNull("options", options);
        BiFunction func = (marker, pageSize) -> {
            FindBlobsOptions finalOptions = pageSize != null ? new FindBlobsOptions(options.getQuery()).setMaxResultsPerPage((Integer)pageSize) : options;
            return this.findBlobsByTags(finalOptions, (String)marker, timeout2, context);
        };
        return new PagedFlux<TaggedBlobItem>(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<PagedResponse<TaggedBlobItem>> findBlobsByTags(FindBlobsOptions options, String marker, Duration timeout2, Context context) {
        this.throwOnAnonymousAccess();
        StorageImplUtils.assertNotNull("options", options);
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getServices().filterBlobsWithResponseAsync(null, null, options.getQuery(), marker, options.getMaxResultsPerPage(), null, context), timeout2).map(response -> {
            List value = ((FilterBlobSegment)response.getValue()).getBlobs().stream().map(ModelHelper::populateTaggedBlobItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FilterBlobSegment)response.getValue()).getNextMarker(), (ServicesFilterBlobsHeaders)response.getDeserializedHeaders());
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<BlobServiceProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        this.throwOnAnonymousAccess();
        return this.azureBlobStorage.getServices().getPropertiesWithResponseAsync(null, null, context).map(rb -> new SimpleResponse<BlobServiceProperties>((Response<?>)rb, (BlobServiceProperties)rb.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setProperties(BlobServiceProperties properties) {
        return this.setPropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesWithResponse(BlobServiceProperties properties) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(properties, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<Void>> setPropertiesWithResponse(BlobServiceProperties properties, Context context) {
        this.throwOnAnonymousAccess();
        BlobServiceProperties finalProperties = null;
        if (properties != null) {
            finalProperties = new BlobServiceProperties();
            finalProperties.setLogging(properties.getLogging());
            if (finalProperties.getLogging() != null) {
                StorageImplUtils.assertNotNull("Logging Version", finalProperties.getLogging().getVersion());
                ModelHelper.validateRetentionPolicy(finalProperties.getLogging().getRetentionPolicy(), "Logging Retention Policy");
            }
            finalProperties.setHourMetrics(properties.getHourMetrics());
            if (finalProperties.getHourMetrics() != null) {
                StorageImplUtils.assertNotNull("HourMetrics Version", finalProperties.getHourMetrics().getVersion());
                ModelHelper.validateRetentionPolicy(finalProperties.getHourMetrics().getRetentionPolicy(), "HourMetrics Retention Policy");
                if (finalProperties.getHourMetrics().isEnabled()) {
                    StorageImplUtils.assertNotNull("HourMetrics IncludeApis", finalProperties.getHourMetrics().isIncludeApis());
                }
            }
            finalProperties.setMinuteMetrics(properties.getMinuteMetrics());
            if (finalProperties.getMinuteMetrics() != null) {
                StorageImplUtils.assertNotNull("MinuteMetrics Version", finalProperties.getMinuteMetrics().getVersion());
                ModelHelper.validateRetentionPolicy(finalProperties.getMinuteMetrics().getRetentionPolicy(), "MinuteMetrics Retention Policy");
                if (finalProperties.getMinuteMetrics().isEnabled()) {
                    StorageImplUtils.assertNotNull("MinuteMetrics IncludeApis", finalProperties.getHourMetrics().isIncludeApis());
                }
            }
            ArrayList<BlobCorsRule> corsRules = new ArrayList<BlobCorsRule>();
            for (BlobCorsRule rule : properties.getCors()) {
                corsRules.add(ModelHelper.validatedCorsRule(rule));
            }
            finalProperties.setCors(corsRules);
            finalProperties.setDefaultServiceVersion(properties.getDefaultServiceVersion());
            finalProperties.setDeleteRetentionPolicy(properties.getDeleteRetentionPolicy());
            ModelHelper.validateRetentionPolicy(finalProperties.getDeleteRetentionPolicy(), "DeleteRetentionPolicy Days");
            finalProperties.setStaticWebsite(properties.getStaticWebsite());
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getServices().setPropertiesNoCustomHeadersWithResponseAsync(finalProperties, null, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserDelegationKey> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return this.getUserDelegationKeyWithResponse(start, expiry).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UserDelegationKey>> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry) {
        try {
            return FluxUtil.withContext(context -> this.getUserDelegationKeyWithResponse(start, expiry, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<UserDelegationKey>> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry, Context context) {
        StorageImplUtils.assertNotNull("expiry", expiry);
        if (start != null && !start.isBefore(expiry)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("`start` must be null or a datetime before `expiry`."));
        }
        this.throwOnAnonymousAccess();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getServices().getUserDelegationKeyWithResponseAsync(new KeyInfo().setStart(start == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(start)).setExpiry(Constants.ISO_8601_UTC_DATE_FORMATTER.format(expiry)), null, null, context).map(rb -> new SimpleResponse<UserDelegationKey>((Response<?>)rb, (UserDelegationKey)rb.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobServiceStatistics> getStatistics() {
        return this.getStatisticsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobServiceStatistics>> getStatisticsWithResponse() {
        try {
            return FluxUtil.withContext(this::getStatisticsWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<BlobServiceStatistics>> getStatisticsWithResponse(Context context) {
        this.throwOnAnonymousAccess();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getServices().getStatisticsWithResponseAsync(null, null, context).map(rb -> new SimpleResponse<BlobServiceStatistics>((Response<?>)rb, (BlobServiceStatistics)rb.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountInfo> getAccountInfo() {
        return this.getAccountInfoWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse() {
        try {
            return FluxUtil.withContext(this::getAccountInfoWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<StorageAccountInfo>> getAccountInfoWithResponse(Context context) {
        this.throwOnAnonymousAccess();
        return this.azureBlobStorage.getServices().getAccountInfoWithResponseAsync(null, null, context).map(rb -> {
            ServicesGetAccountInfoHeaders hd = (ServicesGetAccountInfoHeaders)rb.getDeserializedHeaders();
            return new SimpleResponse<StorageAccountInfo>((Response<?>)rb, new StorageAccountInfo(hd.getXMsSkuName(), hd.getXMsAccountKind(), hd.isXMsIsHnsEnabled()));
        });
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, Context.NONE);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.generateAccountSas(accountSasSignatureValues, null, context);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        this.throwOnAnonymousAccess();
        return new AccountSasImplUtil(accountSasSignatureValues, this.encryptionScope == null ? null : this.encryptionScope.getEncryptionScope()).generateSas(SasImplUtils.extractSharedKeyCredential(this.getHttpPipeline()), stringToSignHandler, context);
    }

    private void throwOnAnonymousAccess() {
        if (this.anonymousAccess) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Service client cannot be accessed without credentials"));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobContainerAsyncClient> undeleteBlobContainer(String deletedContainerName, String deletedContainerVersion) {
        try {
            return this.undeleteBlobContainerWithResponse(new UndeleteBlobContainerOptions(deletedContainerName, deletedContainerVersion)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobContainerAsyncClient>> undeleteBlobContainerWithResponse(UndeleteBlobContainerOptions options) {
        try {
            return FluxUtil.withContext(context -> this.undeleteBlobContainerWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<BlobContainerAsyncClient>> undeleteBlobContainerWithResponse(UndeleteBlobContainerOptions options, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        boolean hasOptionalDestinationContainerName = options.getDestinationContainerName() != null;
        String finalDestinationContainerName = hasOptionalDestinationContainerName ? options.getDestinationContainerName() : options.getDeletedContainerName();
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getContainers().restoreWithResponseAsync(finalDestinationContainerName, null, null, options.getDeletedContainerName(), options.getDeletedContainerVersion(), context).map(response -> new SimpleResponse<BlobContainerAsyncClient>((Response<?>)response, this.getBlobContainerAsyncClient(finalDestinationContainerName)));
    }
}

