/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobPropertiesInternal;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobsGetPropertiesHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util.ModelHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.AccessTier;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ArchiveStatus;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CopyStatusType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseDurationType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseStateType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseStatusType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.RehydratePriority;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class BlobPropertiesInternalGetProperties
implements BlobPropertiesInternal {
    private final BlobsGetPropertiesHeaders headers;

    public BlobPropertiesInternalGetProperties(BlobsGetPropertiesHeaders headers) {
        this.headers = headers;
    }

    @Override
    public OffsetDateTime getCreationTime() {
        return this.headers.getXMsCreationTime();
    }

    @Override
    public OffsetDateTime getLastModified() {
        return this.headers.getLastModified();
    }

    @Override
    public String getETag() {
        return this.headers.getETag();
    }

    @Override
    public long getBlobSize() {
        return this.headers.getContentLength() == null ? 0L : this.headers.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.headers.getContentType();
    }

    @Override
    public byte[] getContentMd5() {
        return this.headers.getContentMD5();
    }

    @Override
    public String getContentEncoding() {
        return this.headers.getContentEncoding();
    }

    @Override
    public String getContentDisposition() {
        return this.headers.getContentDisposition();
    }

    @Override
    public String getContentLanguage() {
        return this.headers.getContentLanguage();
    }

    @Override
    public String getCacheControl() {
        return this.headers.getCacheControl();
    }

    @Override
    public Long getBlobSequenceNumber() {
        return this.headers.getXMsBlobSequenceNumber();
    }

    @Override
    public BlobType getBlobType() {
        return this.headers.getXMsBlobType();
    }

    @Override
    public LeaseStatusType getLeaseStatus() {
        return this.headers.getXMsLeaseStatus();
    }

    @Override
    public LeaseStateType getLeaseState() {
        return this.headers.getXMsLeaseState();
    }

    @Override
    public LeaseDurationType getLeaseDuration() {
        return this.headers.getXMsLeaseDuration();
    }

    @Override
    public String getCopyId() {
        return this.headers.getXMsCopyId();
    }

    @Override
    public CopyStatusType getCopyStatus() {
        return this.headers.getXMsCopyStatus();
    }

    @Override
    public String getCopySource() {
        return this.headers.getXMsCopySource();
    }

    @Override
    public String getCopyProgress() {
        return this.headers.getXMsCopyProgress();
    }

    @Override
    public OffsetDateTime getCopyCompletionTime() {
        return this.headers.getXMsCopyCompletionTime();
    }

    @Override
    public String getCopyStatusDescription() {
        return this.headers.getXMsCopyStatusDescription();
    }

    @Override
    public Boolean isServerEncrypted() {
        return this.headers.isXMsServerEncrypted();
    }

    @Override
    public Boolean isIncrementalCopy() {
        return this.headers.isXMsIncrementalCopy();
    }

    @Override
    public String getCopyDestinationSnapshot() {
        return this.headers.getXMsCopyDestinationSnapshot();
    }

    @Override
    public AccessTier getAccessTier() {
        return AccessTier.fromString(this.headers.getXMsAccessTier());
    }

    @Override
    public Boolean isAccessTierInferred() {
        return this.headers.isXMsAccessTierInferred();
    }

    @Override
    public ArchiveStatus getArchiveStatus() {
        return ArchiveStatus.fromString(this.headers.getXMsArchiveStatus());
    }

    @Override
    public String getEncryptionKeySha256() {
        return this.headers.getXMsEncryptionKeySha256();
    }

    @Override
    public String getEncryptionScope() {
        return this.headers.getXMsEncryptionScope();
    }

    @Override
    public OffsetDateTime getAccessTierChangeTime() {
        return this.headers.getXMsAccessTierChangeTime();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.headers.getXMsMeta();
    }

    @Override
    public Integer getCommittedBlockCount() {
        return this.headers.getXMsBlobCommittedBlockCount();
    }

    @Override
    public Long getTagCount() {
        return this.headers.getXMsTagCount();
    }

    @Override
    public String getVersionId() {
        return this.headers.getXMsVersionId();
    }

    @Override
    public Boolean isCurrentVersion() {
        return this.headers.isXMsIsCurrentVersion();
    }

    @Override
    public List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies() {
        return ModelHelper.getObjectReplicationSourcePolicies(this.headers.getXMsOr());
    }

    @Override
    public String getObjectReplicationDestinationPolicyId() {
        return ModelHelper.getObjectReplicationDestinationPolicyId(this.headers.getXMsOr());
    }

    @Override
    public RehydratePriority getRehydratePriority() {
        return RehydratePriority.fromString(this.headers.getXMsRehydratePriority());
    }

    @Override
    public Boolean isSealed() {
        return this.headers.isXMsBlobSealed();
    }

    @Override
    public OffsetDateTime getLastAccessedTime() {
        return this.headers.getXMsLastAccessTime();
    }

    @Override
    public OffsetDateTime getExpiresOn() {
        return this.headers.getXMsExpiryTime();
    }

    @Override
    public BlobImmutabilityPolicy getImmutabilityPolicy() {
        return new BlobImmutabilityPolicy().setExpiryTime(this.headers.getXMsImmutabilityPolicyUntilDate()).setPolicyMode(this.headers.getXMsImmutabilityPolicyMode());
    }

    @Override
    public Boolean hasLegalHold() {
        return this.headers.isXMsLegalHold();
    }

    @Override
    public String getRequestId() {
        return this.headers.getXMsRequestId();
    }
}

