/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import java.time.OffsetDateTime;

public class AppendBlobItem {
    private final String eTag;
    private final OffsetDateTime lastModified;
    private final byte[] contentMd5;
    private final boolean isServerEncrypted;
    private final String encryptionKeySha256;
    private final String encryptionScope;
    private final String blobAppendOffset;
    private final Integer blobCommittedBlockCount;
    private final String versionId;

    public AppendBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, boolean isServerEncrypted, String encryptionKeySha256, String blobAppendOffset, Integer blobCommittedBlockCount) {
        this(eTag, lastModified, contentMd5, isServerEncrypted, encryptionKeySha256, null, blobAppendOffset, blobCommittedBlockCount);
    }

    public AppendBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, boolean isServerEncrypted, String encryptionKeySha256, String encryptionScope, String blobAppendOffset, Integer blobCommittedBlockCount) {
        this(eTag, lastModified, contentMd5, isServerEncrypted, encryptionKeySha256, encryptionScope, blobAppendOffset, blobCommittedBlockCount, null);
    }

    public AppendBlobItem(String eTag, OffsetDateTime lastModified, byte[] contentMd5, boolean isServerEncrypted, String encryptionKeySha256, String encryptionScope, String blobAppendOffset, Integer blobCommittedBlockCount, String versionId) {
        this.eTag = eTag;
        this.lastModified = lastModified;
        this.contentMd5 = CoreUtils.clone(contentMd5);
        this.isServerEncrypted = isServerEncrypted;
        this.encryptionKeySha256 = encryptionKeySha256;
        this.encryptionScope = encryptionScope;
        this.blobAppendOffset = blobAppendOffset;
        this.blobCommittedBlockCount = blobCommittedBlockCount;
        this.versionId = versionId;
    }

    public String getETag() {
        return this.eTag;
    }

    public OffsetDateTime getLastModified() {
        return this.lastModified;
    }

    public boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone(this.contentMd5);
    }

    public String getBlobAppendOffset() {
        return this.blobAppendOffset;
    }

    public Integer getBlobCommittedBlockCount() {
        return this.blobCommittedBlockCount;
    }

    public String getVersionId() {
        return this.versionId;
    }
}

