/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.Block;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlockList
implements XmlSerializable<BlockList> {
    private List<Block> committedBlocks;
    private List<Block> uncommittedBlocks;

    public List<Block> getCommittedBlocks() {
        if (this.committedBlocks == null) {
            this.committedBlocks = new ArrayList<Block>();
        }
        return this.committedBlocks;
    }

    public BlockList setCommittedBlocks(List<Block> committedBlocks) {
        this.committedBlocks = committedBlocks;
        return this;
    }

    public List<Block> getUncommittedBlocks() {
        if (this.uncommittedBlocks == null) {
            this.uncommittedBlocks = new ArrayList<Block>();
        }
        return this.uncommittedBlocks;
    }

    public BlockList setUncommittedBlocks(List<Block> uncommittedBlocks) {
        this.uncommittedBlocks = uncommittedBlocks;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "BlockList" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.committedBlocks != null) {
            xmlWriter.writeStartElement("CommittedBlocks");
            for (Block element : this.committedBlocks) {
                xmlWriter.writeXml(element, "Block");
            }
            xmlWriter.writeEndElement();
        }
        if (this.uncommittedBlocks != null) {
            xmlWriter.writeStartElement("UncommittedBlocks");
            for (Block element : this.uncommittedBlocks) {
                xmlWriter.writeXml(element, "Block");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static BlockList fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlockList.fromXml(xmlReader, null);
    }

    public static BlockList fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "BlockList" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlockList deserializedBlockList = new BlockList();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("CommittedBlocks".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Block".equals(elementName.getLocalPart())) {
                            if (deserializedBlockList.committedBlocks == null) {
                                deserializedBlockList.committedBlocks = new ArrayList<Block>();
                            }
                            deserializedBlockList.committedBlocks.add(Block.fromXml(reader, "Block"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("UncommittedBlocks".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("Block".equals(elementName.getLocalPart())) {
                            if (deserializedBlockList.uncommittedBlocks == null) {
                                deserializedBlockList.uncommittedBlocks = new ArrayList<Block>();
                            }
                            deserializedBlockList.uncommittedBlocks.add(Block.fromXml(reader, "Block"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlockList;
        });
    }
}

