/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share;

import com.dataiku.dss.shadelibazure.com.azure.storage.common.StorageOutputStream;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.ShareFileAsyncClient;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.nio.ByteBuffer;

public class StorageFileOutputStream
extends StorageOutputStream {
    private long offsetPos;
    private final ShareFileAsyncClient client;

    StorageFileOutputStream(ShareFileAsyncClient client, long offsetPos) {
        super(0x400000);
        this.client = client;
        this.offsetPos = offsetPos;
    }

    private Mono<Void> uploadData(Flux<ByteBuffer> inputData, long writeLength, long offset) {
        return this.client.uploadWithResponse(inputData, writeLength, offset).then();
    }

    @Override
    protected Mono<Void> dispatchWrite(byte[] data, int writeLength, long offset) {
        if (writeLength == 0) {
            return Mono.empty();
        }
        Flux<ByteBuffer> fbb = Mono.fromCallable(() -> ByteBuffer.wrap(data, (int)offset, writeLength)).flux();
        long fileOffset = this.offsetPos;
        this.offsetPos += (long)writeLength;
        return this.uploadData(fbb, writeLength, fileOffset);
    }
}

