/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.FileProperty;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.models.StringEncoded;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class DirectoryItem
implements XmlSerializable<DirectoryItem> {
    private StringEncoded name;
    private String fileId;
    private FileProperty properties;
    private String attributes;
    private String permissionKey;

    public StringEncoded getName() {
        return this.name;
    }

    public DirectoryItem setName(StringEncoded name) {
        this.name = name;
        return this;
    }

    public String getFileId() {
        return this.fileId;
    }

    public DirectoryItem setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public FileProperty getProperties() {
        return this.properties;
    }

    public DirectoryItem setProperties(FileProperty properties) {
        this.properties = properties;
        return this;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public DirectoryItem setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public String getPermissionKey() {
        return this.permissionKey;
    }

    public DirectoryItem setPermissionKey(String permissionKey) {
        this.permissionKey = permissionKey;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Directory" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml(this.name, "Name");
        xmlWriter.writeStringElement("FileId", this.fileId);
        xmlWriter.writeXml(this.properties, "Properties");
        xmlWriter.writeStringElement("Attributes", this.attributes);
        xmlWriter.writeStringElement("PermissionKey", this.permissionKey);
        return xmlWriter.writeEndElement();
    }

    public static DirectoryItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return DirectoryItem.fromXml(xmlReader, null);
    }

    public static DirectoryItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Directory" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            DirectoryItem deserializedDirectoryItem = new DirectoryItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedDirectoryItem.name = StringEncoded.fromXml(reader, "Name");
                    continue;
                }
                if ("FileId".equals(elementName.getLocalPart())) {
                    deserializedDirectoryItem.fileId = reader.getStringElement();
                    continue;
                }
                if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedDirectoryItem.properties = FileProperty.fromXml(reader, "Properties");
                    continue;
                }
                if ("Attributes".equals(elementName.getLocalPart())) {
                    deserializedDirectoryItem.attributes = reader.getStringElement();
                    continue;
                }
                if ("PermissionKey".equals(elementName.getLocalPart())) {
                    deserializedDirectoryItem.permissionKey = reader.getStringElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedDirectoryItem;
        });
    }
}

