/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.xml;

import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class XmlWriter
implements AutoCloseable {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private final XMLStreamWriter writer;

    public static XmlWriter toStream(OutputStream xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return new XmlWriter(XML_OUTPUT_FACTORY.createXMLStreamWriter(new OutputStreamWriter(xml, StandardCharsets.UTF_8)));
    }

    public static XmlWriter toWriter(Writer xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return new XmlWriter(XML_OUTPUT_FACTORY.createXMLStreamWriter(xml));
    }

    public static XmlWriter fromXmlStreamWriter(XMLStreamWriter writer) {
        return new XmlWriter(writer);
    }

    private XmlWriter(XMLStreamWriter writer) {
        this.writer = Objects.requireNonNull(writer, "'writer' cannot be null.");
    }

    public XmlWriter writeStartDocument() throws XMLStreamException {
        return this.writeStartDocument("1.0", "UTF-8");
    }

    public XmlWriter writeStartDocument(String version, String encoding) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
        return this;
    }

    public XmlWriter writeStartElement(String localName) throws XMLStreamException {
        return this.writeStartElement(null, localName);
    }

    public XmlWriter writeStartElement(String namespaceUri, String localName) throws XMLStreamException {
        if (namespaceUri == null) {
            this.writer.writeStartElement(localName);
        } else {
            this.writer.writeStartElement(namespaceUri, localName);
        }
        return this;
    }

    public XmlWriter writeStartSelfClosingElement(String localName) throws XMLStreamException {
        return this.writeStartSelfClosingElement(null, localName);
    }

    public XmlWriter writeStartSelfClosingElement(String namespaceUri, String localName) throws XMLStreamException {
        if (namespaceUri == null) {
            this.writer.writeEmptyElement(localName);
        } else {
            this.writer.writeEmptyElement(namespaceUri, localName);
        }
        return this;
    }

    public XmlWriter writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
        return this;
    }

    public XmlWriter writeNamespace(String namespaceUri) throws XMLStreamException {
        if (Objects.equals(this.writer.getNamespaceContext().getNamespaceURI(""), namespaceUri)) {
            return this;
        }
        this.writer.setDefaultNamespace(namespaceUri);
        this.writer.writeDefaultNamespace(namespaceUri);
        return this;
    }

    public XmlWriter writeNamespace(String namespacePrefix, String namespaceUri) throws XMLStreamException {
        if (namespacePrefix == null || "xmlns".equals(namespacePrefix)) {
            return this.writeNamespace(namespacePrefix);
        }
        if (Objects.equals(this.writer.getNamespaceContext().getNamespaceURI(namespacePrefix), namespaceUri)) {
            return this;
        }
        this.writer.writeNamespace(namespacePrefix, namespaceUri);
        return this;
    }

    public XmlWriter writeStringAttribute(String localName, String value) throws XMLStreamException {
        return this.writeStringAttribute(null, localName, value);
    }

    public XmlWriter writeStringAttribute(String namespaceUri, String localName, String value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        if (namespaceUri == null) {
            this.writer.writeAttribute(localName, value);
        } else {
            this.writer.writeAttribute(namespaceUri, localName, value);
        }
        return this;
    }

    public XmlWriter writeBinaryAttribute(String localName, byte[] value) throws XMLStreamException {
        return this.writeBinaryAttribute(null, localName, value);
    }

    public XmlWriter writeBinaryAttribute(String namespaceUri, String localName, byte[] value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStringAttribute(namespaceUri, localName, XmlWriter.convertBytesToString(value));
    }

    public XmlWriter writeBooleanAttribute(String localName, boolean value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public XmlWriter writeBooleanAttribute(String namespaceUri, String localName, boolean value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public XmlWriter writeBooleanAttribute(String localName, Boolean value) throws XMLStreamException {
        return this.writeBooleanAttribute((String)null, localName, value);
    }

    public XmlWriter writeBooleanAttribute(String namespaceUri, String localName, Boolean value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public XmlWriter writeDoubleAttribute(String localName, double value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public XmlWriter writeDoubleAttribute(String namespaceUri, String localName, double value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public XmlWriter writeFloatAttribute(String localName, float value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public XmlWriter writeFloatAttribute(String namespaceUri, String localName, float value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public XmlWriter writeIntAttribute(String localName, int value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public XmlWriter writeIntAttribute(String namespaceUri, String localName, int value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public XmlWriter writeLongAttribute(String localName, long value) throws XMLStreamException {
        return this.writeStringAttribute(localName, String.valueOf(value));
    }

    public XmlWriter writeLongAttribute(String namespaceUri, String localName, long value) throws XMLStreamException {
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public XmlWriter writeNumberAttribute(String localName, Number value) throws XMLStreamException {
        return this.writeNumberAttribute(null, localName, value);
    }

    public XmlWriter writeNumberAttribute(String namespaceUri, String localName, Number value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStringAttribute(namespaceUri, localName, String.valueOf(value));
    }

    public XmlWriter writeBinaryElement(String localName, byte[] value) throws XMLStreamException {
        return this.writeBinaryElement(null, localName, value);
    }

    public XmlWriter writeBinaryElement(String namespaceUri, String localName, byte[] value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStartElement(namespaceUri, localName).writeBinary(value).writeEndElement();
    }

    public XmlWriter writeBooleanElement(String localName, boolean value) throws XMLStreamException {
        return this.writeBooleanElement((String)null, localName, value);
    }

    public XmlWriter writeBooleanElement(String namespaceUri, String localName, boolean value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeBoolean(value).writeEndElement();
    }

    public XmlWriter writeBooleanElement(String localName, Boolean value) throws XMLStreamException {
        return this.writeBooleanElement((String)null, localName, value);
    }

    public XmlWriter writeBooleanElement(String namespaceUri, String localName, Boolean value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStartElement(namespaceUri, localName).writeBoolean((boolean)value).writeEndElement();
    }

    public XmlWriter writeDoubleElement(String localName, double value) throws XMLStreamException {
        return this.writeDoubleElement(null, localName, value);
    }

    public XmlWriter writeDoubleElement(String namespaceUri, String localName, double value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeDouble(value).writeEndElement();
    }

    public XmlWriter writeFloatElement(String localName, float value) throws XMLStreamException {
        return this.writeFloatElement(null, localName, value);
    }

    public XmlWriter writeFloatElement(String namespaceUri, String localName, float value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeFloat(value).writeEndElement();
    }

    public XmlWriter writeIntElement(String localName, int value) throws XMLStreamException {
        return this.writeIntElement(null, localName, value);
    }

    public XmlWriter writeIntElement(String namespaceUri, String localName, int value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeInt(value).writeEndElement();
    }

    public XmlWriter writeLongElement(String localName, long value) throws XMLStreamException {
        return this.writeLongElement(null, localName, value);
    }

    public XmlWriter writeLongElement(String namespaceUri, String localName, long value) throws XMLStreamException {
        return this.writeStartElement(namespaceUri, localName).writeLong(value).writeEndElement();
    }

    public XmlWriter writeNumberElement(String localName, Number value) throws XMLStreamException {
        return this.writeNumberElement(null, localName, value);
    }

    public XmlWriter writeNumberElement(String namespaceUri, String localName, Number value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStartElement(namespaceUri, localName).writeNumber(value).writeEndElement();
    }

    public XmlWriter writeStringElement(String localName, String value) throws XMLStreamException {
        return this.writeStringElement(null, localName, value);
    }

    public XmlWriter writeStringElement(String namespaceUri, String localName, String value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        return this.writeStartElement(namespaceUri, localName).writeString(value).writeEndElement();
    }

    public XmlWriter writeXml(XmlSerializable<?> value) throws XMLStreamException {
        return this.writeXml(value, null);
    }

    public XmlWriter writeXml(XmlSerializable<?> value, String rootElementName) throws XMLStreamException {
        return value == null ? this : value.toXml(this, rootElementName);
    }

    public XmlWriter writeBinary(byte[] value) throws XMLStreamException {
        return value == null ? this : this.writeString(XmlWriter.convertBytesToString(value));
    }

    public XmlWriter writeBoolean(boolean value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public XmlWriter writeBoolean(Boolean value) throws XMLStreamException {
        return value == null ? this : this.writeString(String.valueOf(value));
    }

    public XmlWriter writeDouble(double value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public XmlWriter writeFloat(float value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public XmlWriter writeInt(int value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public XmlWriter writeLong(long value) throws XMLStreamException {
        return this.writeString(String.valueOf(value));
    }

    public XmlWriter writeNumber(Number value) throws XMLStreamException {
        return value == null ? this : this.writeString(String.valueOf(value));
    }

    public XmlWriter writeString(String value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        this.writer.writeCharacters(value);
        return this;
    }

    public XmlWriter writeCDataString(String value) throws XMLStreamException {
        if (value == null) {
            return this;
        }
        this.writer.writeCData(value);
        return this;
    }

    public XmlWriter flush() throws XMLStreamException {
        this.writer.flush();
        return this;
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.flush();
        this.writer.close();
    }

    private static String convertBytesToString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(bytes);
    }
}

