/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4jextensions;

import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4jextensions.CacheFileLockAcquisitionException;
import com.dataiku.dss.shadelibazure.org.slf4j.Logger;
import com.dataiku.dss.shadelibazure.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;

class CrossProcessCacheFileLock {
    private static final Logger LOG = LoggerFactory.getLogger(CrossProcessCacheFileLock.class);
    private int retryDelayMilliseconds;
    private int retryNumber;
    private File lockFile;
    private FileLock lock;
    private FileChannel fileChannel;
    private boolean locked;

    CrossProcessCacheFileLock(String lockfileName, int retryDelayMilliseconds, int retryNumber) {
        this.lockFile = new File(lockfileName);
        this.retryDelayMilliseconds = retryDelayMilliseconds;
        this.retryNumber = retryNumber;
    }

    private String getProcessId() {
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        return vmName.substring(0, vmName.indexOf("@"));
    }

    private String getLockProcessThreadId() {
        return "pid:" + this.getProcessId() + " thread:" + Thread.currentThread().getId();
    }

    private boolean tryToCreateLockFile() {
        for (int tryCount = 0; tryCount < this.retryNumber; ++tryCount) {
            boolean fileCreated = false;
            try {
                fileCreated = this.lockFile.createNewFile();
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage());
            }
            if (fileCreated) {
                return true;
            }
            this.waitBeforeRetry();
        }
        return false;
    }

    private void waitBeforeRetry() {
        try {
            Thread.sleep(this.retryDelayMilliseconds);
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage());
        }
    }

    void lock() throws CacheFileLockAcquisitionException {
        if (!this.tryToCreateLockFile()) {
            LOG.debug(this.getLockProcessThreadId() + " Failed to create lock file!");
        }
        for (int tryCount = 0; tryCount < this.retryNumber; ++tryCount) {
            try {
                this.lockFile.createNewFile();
                LOG.debug(this.getLockProcessThreadId() + " acquiring file lock");
                this.fileChannel = FileChannel.open(this.lockFile.toPath(), StandardOpenOption.READ, StandardOpenOption.SYNC, StandardOpenOption.WRITE);
                this.lock = this.fileChannel.tryLock();
                if (this.lock == null) {
                    throw new IllegalStateException("Lock is not available");
                }
                this.writeJvmName(this.fileChannel);
                this.locked = true;
                LOG.debug(this.getLockProcessThreadId() + " acquired OK file lock");
                return;
            }
            catch (Exception ex) {
                LOG.debug(this.getLockProcessThreadId() + " failed to acquire lock, exception msg - " + ex.getMessage());
                this.releaseResources();
                this.waitBeforeRetry();
                continue;
            }
        }
        LOG.error(this.getLockProcessThreadId() + " failed to acquire lock");
        throw new CacheFileLockAcquisitionException(this.getLockProcessThreadId() + " failed to acquire lock");
    }

    private void writeJvmName(FileChannel fileChannel) throws IOException {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        ByteBuffer buff = ByteBuffer.wrap(jvmName.replace("@", " ").getBytes(StandardCharsets.UTF_8));
        fileChannel.write(buff);
    }

    void unlock() throws IOException {
        LOG.debug(this.getLockProcessThreadId() + " releasing lock");
        this.releaseResources();
        if (this.locked) {
            this.deleteLockFile();
            this.locked = false;
        }
    }

    private void deleteLockFile() throws IOException {
        if (!Files.deleteIfExists(this.lockFile.toPath())) {
            LOG.debug(this.getLockProcessThreadId() + " FAILED to delete lock file");
        }
    }

    private void releaseResources() {
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage());
        }
    }
}

