/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4jextensions.persistence.mac;

import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4jextensions.persistence.CacheFileAccessor;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4jextensions.persistence.ICacheAccessor;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4jextensions.persistence.mac.ISecurityLibrary;
import com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4jextensions.persistence.mac.KeyChainAccessException;
import com.dataiku.dss.shadelibazure.com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;

public class KeyChainAccessor
implements ICacheAccessor {
    private String cacheFilePath;
    private byte[] serviceNameBytes;
    private byte[] accountNameBytes;

    public KeyChainAccessor(String cacheFilePath, String serviceName, String accountName) {
        this.cacheFilePath = cacheFilePath;
        this.serviceNameBytes = serviceName.getBytes(StandardCharsets.UTF_8);
        this.accountNameBytes = accountName.getBytes(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read() {
        int[] dataLength = new int[1];
        Pointer[] data = new Pointer[1];
        try {
            int status = ISecurityLibrary.library.SecKeychainFindGenericPassword(null, this.serviceNameBytes.length, this.serviceNameBytes, this.accountNameBytes.length, this.accountNameBytes, dataLength, data, null);
            if (status == -25300) {
                byte[] byArray = null;
                return byArray;
            }
            if (status != 0) {
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            byte[] byArray = data[0].getByteArray(0L, dataLength[0]);
            return byArray;
        }
        finally {
            ISecurityLibrary.library.SecKeychainItemFreeContent(null, data[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeNoRetry(byte[] data) {
        int status;
        block6: {
            Pointer[] itemRef = new Pointer[1];
            try {
                status = ISecurityLibrary.library.SecKeychainFindGenericPassword(null, this.serviceNameBytes.length, this.serviceNameBytes, this.accountNameBytes.length, this.accountNameBytes, null, null, itemRef);
                if (status == 0 && itemRef[0] != null) {
                    status = ISecurityLibrary.library.SecKeychainItemModifyContent(itemRef[0], null, data.length, data);
                    break block6;
                }
                if (status == -25300) {
                    status = ISecurityLibrary.library.SecKeychainAddGenericPassword(null, this.serviceNameBytes.length, this.serviceNameBytes, this.accountNameBytes.length, this.accountNameBytes, data.length, data, null);
                    break block6;
                }
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            finally {
                if (itemRef[0] != null) {
                    ISecurityLibrary.library.CFRelease(itemRef[0]);
                }
            }
        }
        return status;
    }

    @Override
    public void write(byte[] data) {
        int NUM_OF_RETRIES = 3;
        int RETRY_DELAY_IN_MS = 10;
        int status = 0;
        for (int i = 0; i < NUM_OF_RETRIES; ++i) {
            status = this.writeNoRetry(data);
            if (status == 0) {
                new CacheFileAccessor(this.cacheFilePath).updateCacheFileLastModifiedTime();
                return;
            }
            try {
                Thread.sleep(RETRY_DELAY_IN_MS);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
    }

    @Override
    public void delete() {
        Pointer[] itemRef = new Pointer[1];
        try {
            int status = ISecurityLibrary.library.SecKeychainFindGenericPassword(null, this.serviceNameBytes.length, this.serviceNameBytes, this.accountNameBytes.length, this.accountNameBytes, null, null, itemRef);
            if (status == -25300) {
                return;
            }
            if (status != 0) {
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            if (itemRef[0] != null && (status = ISecurityLibrary.library.SecKeychainItemDelete(itemRef[0])) != 0) {
                throw new KeyChainAccessException(this.convertErrorCodeToMessage(status));
            }
            new CacheFileAccessor(this.cacheFilePath).updateCacheFileLastModifiedTime();
        }
        finally {
            if (itemRef[0] != null) {
                ISecurityLibrary.library.CFRelease(itemRef[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertErrorCodeToMessage(int errorCode) {
        Pointer msgPtr = null;
        try {
            msgPtr = ISecurityLibrary.library.SecCopyErrorMessageString(errorCode, null);
            if (msgPtr == null) {
                String string = null;
                return string;
            }
            int bufSize = ISecurityLibrary.library.CFStringGetLength(msgPtr);
            char[] buf = new char[bufSize];
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = ISecurityLibrary.library.CFStringGetCharacterAtIndex(msgPtr, i);
            }
            String string = new String(buf);
            return string;
        }
        finally {
            if (msgPtr != null) {
                ISecurityLibrary.library.CFRelease(msgPtr);
            }
        }
    }
}

