/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore;

import com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore.middlewareoption.MiddlewareType;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore.middlewareoption.TelemetryOptions;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.okhttp3.Interceptor;
import com.dataiku.dss.shadelibazure.okhttp3.MediaType;
import com.dataiku.dss.shadelibazure.okhttp3.Protocol;
import com.dataiku.dss.shadelibazure.okhttp3.Request;
import com.dataiku.dss.shadelibazure.okhttp3.Response;
import com.dataiku.dss.shadelibazure.okhttp3.ResponseBody;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;

public class ChaosHttpHandler
implements Interceptor {
    public final MiddlewareType MIDDLEWARE_TYPE = MiddlewareType.RETRY;
    private static final String RETRY_AFTER = "Retry-After";
    private static final int failureRate = 3;
    private static final String retryAfterValue = "10";
    private static final String responseBody = "{\"error\": {\"code\": \"TooManyRequests\",\"innerError\": {\"code\": \"429\",\"date\": \"2020-08-18T12:51:51\",\"message\": \"Please retry after\",\"request-id\": \"94fb3b52-452a-4535-a601-69e0a90e3aa2\",\"status\": \"429\"},\"message\": \"Please retry again later.\"}}";
    public static final int MSClientErrorCodeTooManyRequests = 429;

    @Override
    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        TelemetryOptions telemetryOptions = request.tag(TelemetryOptions.class);
        if (telemetryOptions == null) {
            telemetryOptions = new TelemetryOptions();
            request = request.newBuilder().tag(TelemetryOptions.class, telemetryOptions).build();
        }
        telemetryOptions.setFeatureUsage(2);
        int dice = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        if (dice % 3 == 0) {
            return new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(429).message("Too Many Requests").addHeader(RETRY_AFTER, retryAfterValue).body(ResponseBody.create(responseBody, MediaType.get("application/json"))).build();
        }
        return chain.proceed(request);
    }
}

