/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer;

import com.dataiku.dss.shadelibazure.com.google.gson.JsonArray;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonElement;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonObject;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonParseException;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonParser;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.BaseCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.BaseCollectionResponse;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.BaseRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.logger.ILogger;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.CollectionResponseDeserializer;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.DefaultSerializer;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;

public class CollectionPageSerializer {
    private static DefaultSerializer serializer;
    private static final int responseLength = 8;
    private static final int pageLength = 4;

    private CollectionPageSerializer() {
    }

    @Nullable
    public static <T1, T2 extends BaseRequestBuilder<T1>> JsonElement serialize(@Nonnull BaseCollectionPage<T1, T2> src, @Nonnull ILogger logger) {
        if (src == null) {
            return null;
        }
        Objects.requireNonNull(logger, "parameter logger cannot be null");
        JsonArray jsonArray = new JsonArray();
        List<T1> items = src.getCurrentPage();
        serializer = new DefaultSerializer(logger);
        for (T1 item : items) {
            String json = serializer.serializeObject(item);
            JsonElement element = JsonParser.parseString(json);
            if (element == null || !element.isJsonObject()) continue;
            JsonObject jsonObject = element.getAsJsonObject();
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    @Nullable
    public static <T1, T2 extends BaseRequestBuilder<T1>> BaseCollectionPage<T1, T2> deserialize(@Nonnull JsonElement json, @Nonnull Type typeOfT, @Nonnull ILogger logger) throws JsonParseException {
        if (json == null || !json.isJsonArray() || !typeOfT.getClass().equals(Class.class)) {
            return null;
        }
        serializer = new DefaultSerializer(logger);
        String collectionPageClassCanonicalName = ((Class)typeOfT).getName();
        try {
            String responseClassCanonicalName = collectionPageClassCanonicalName.substring(0, collectionPageClassCanonicalName.length() - 4) + "Response";
            Class<?> responseClass = Class.forName(responseClassCanonicalName);
            JsonObject responseJson = new JsonObject();
            responseJson.add("value", json);
            BaseCollectionResponse response = CollectionResponseDeserializer.deserialize(responseJson, responseClass, logger);
            String responseBuilderCanonicalName = responseClassCanonicalName.substring(0, responseClassCanonicalName.length() - 8) + "RequestBuilder";
            Class<?> responseBuilderClass = Class.forName(responseBuilderCanonicalName);
            Class<?> collectionPageClass = Class.forName(collectionPageClassCanonicalName);
            return (BaseCollectionPage)collectionPageClass.getConstructor(responseClass, responseBuilderClass).newInstance(response, null);
        }
        catch (ClassNotFoundException ex) {
            logger.logError("Could not find class during deserialization", ex);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            logger.logError("Could not instanciate type during deserialization", ex);
        }
        catch (IllegalAccessException ex) {
            logger.logError("Unable to set field value during deserialization", ex);
        }
        return null;
    }
}

