/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer;

import com.dataiku.dss.shadelibazure.com.google.gson.Gson;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonElement;
import com.dataiku.dss.shadelibazure.com.google.gson.TypeAdapter;
import com.dataiku.dss.shadelibazure.com.google.gson.internal.Streams;
import com.dataiku.dss.shadelibazure.com.google.gson.reflect.TypeToken;
import com.dataiku.dss.shadelibazure.com.google.gson.stream.JsonReader;
import com.dataiku.dss.shadelibazure.com.google.gson.stream.JsonWriter;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.logger.ILogger;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.DerivedClassIdentifier;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.FallbackTypeAdapterFactory;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.IJsonBackedObject;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;

class ODataTypeParametrizedIJsonBackedTypedAdapter
extends TypeAdapter<IJsonBackedObject> {
    private final FallbackTypeAdapterFactory fallbackTypeAdapterFactory;
    private final Gson gson;
    private final TypeAdapter<IJsonBackedObject> delegatedAdapter;
    private final TypeToken<IJsonBackedObject> type;
    private final DerivedClassIdentifier derivedClassIdentifier;

    public ODataTypeParametrizedIJsonBackedTypedAdapter(FallbackTypeAdapterFactory fallbackTypeAdapterFactory, @Nonnull Gson gson, @Nonnull TypeAdapter<IJsonBackedObject> delegatedAdapter, @Nonnull TypeToken<IJsonBackedObject> type, @Nonnull ILogger logger) {
        this.fallbackTypeAdapterFactory = fallbackTypeAdapterFactory;
        this.gson = Objects.requireNonNull(gson, "parameter gson cannot be null");
        this.delegatedAdapter = Objects.requireNonNull(delegatedAdapter, "object delegated adapted cannot be null");
        this.type = Objects.requireNonNull(type, "object type cannot be null");
        this.derivedClassIdentifier = new DerivedClassIdentifier(logger);
    }

    @Override
    public void write(JsonWriter out, IJsonBackedObject value) throws IOException {
        this.delegatedAdapter.write(out, value);
    }

    @Override
    public IJsonBackedObject read(JsonReader in) {
        Class<?> derivedClass;
        JsonElement jsonElement = Streams.parse(in);
        if (jsonElement.isJsonObject() && (derivedClass = this.derivedClassIdentifier.identify(jsonElement.getAsJsonObject(), this.type.getRawType())) != null) {
            TypeAdapter<?> subTypeAdapter = this.gson.getDelegateAdapter(this.fallbackTypeAdapterFactory, TypeToken.get(derivedClass));
            return (IJsonBackedObject)subTypeAdapter.fromJsonTree(jsonElement);
        }
        return this.delegatedAdapter.fromJsonTree(jsonElement);
    }
}

