/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.tasks;

import com.dataiku.dss.shadelibazure.com.microsoft.graph.core.ClientException;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.GraphServiceException;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.tasks.IUploadSession;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import java.util.Objects;

class LargeFileUploadResponse<UploadType> {
    private final String location;
    private final UploadType uploadedItem;
    private final IUploadSession session;
    private final ClientException error;

    protected LargeFileUploadResponse(@Nullable String location) {
        this.location = location;
        this.error = null;
        this.session = null;
        this.uploadedItem = null;
    }

    protected LargeFileUploadResponse(@Nullable UploadType uploaded) {
        this.uploadedItem = uploaded;
        this.session = null;
        this.error = null;
        this.location = null;
    }

    protected LargeFileUploadResponse(@Nullable IUploadSession session) {
        this.session = session;
        this.uploadedItem = null;
        this.error = null;
        this.location = null;
    }

    protected LargeFileUploadResponse(@Nullable ClientException error) {
        this.error = error;
        this.uploadedItem = null;
        this.session = null;
        this.location = null;
    }

    protected LargeFileUploadResponse(@Nonnull GraphServiceException exception) {
        this(new ClientException(Objects.requireNonNull(exception, "parameter exception cannot be null").getMessage(), exception));
    }

    public boolean chunkCompleted() {
        return this.uploadedItem != null || this.session != null;
    }

    public boolean uploadCompleted() {
        return this.uploadedItem != null || this.location != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    @Nullable
    public UploadType getItem() {
        return this.uploadedItem;
    }

    @Nullable
    public IUploadSession getSession() {
        return this.session;
    }

    @Nullable
    public ClientException getError() {
        return this.error;
    }

    @Nullable
    public String getLocation() {
        return this.location;
    }
}

